/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.jobs;

import io.skylite.SkyliteException;
import io.skylite.common.ExceptionsHelper;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public final class LockModel
implements ToXContentObject {
    private static final String LOCK_ID_DELIMITR = "-";
    public static final String JOB_INDEX_NAME = "job_index_name";
    public static final String JOB_ID = "job_id";
    public static final String LOCK_TIME = "lock_time";
    public static final String LOCK_DURATION = "lock_duration_seconds";
    public static final String RELEASED = "released";
    public static final String GET_LOCK_ACTION = "get_lock_action";
    public static final String SEQUENCE_NUMBER = "seq_no";
    public static final String PRIMARY_TERM = "primary_term";
    public static final String LOCK_ID = "lock_id";
    public static final String LOCK_MODEL = "lock_model";
    private final String lockId;
    private final String jobIndexName;
    private final String jobId;
    private final Instant lockTime;
    private final long lockDurationSeconds;
    private final boolean released;
    private final long seqNo;
    private final long primaryTerm;

    public LockModel(LockModel copyLock, long seqNo, long primaryTerm) {
        this(copyLock.jobIndexName, copyLock.jobId, copyLock.lockTime, copyLock.lockDurationSeconds, copyLock.released, seqNo, primaryTerm);
    }

    public LockModel(LockModel copyLock, boolean released) {
        this(copyLock.jobIndexName, copyLock.jobId, copyLock.lockTime, copyLock.lockDurationSeconds, released, copyLock.seqNo, copyLock.primaryTerm);
    }

    public LockModel(LockModel copyLock, Instant updateLockTime, long lockDurationSeconds, boolean released) {
        this(copyLock.jobIndexName, copyLock.jobId, updateLockTime, lockDurationSeconds, released, copyLock.seqNo, copyLock.primaryTerm);
    }

    public LockModel(String jobIndexName, String jobId, Instant lockTime, long lockDurationSeconds, boolean released) {
        this(jobIndexName, jobId, lockTime, lockDurationSeconds, released, -2L, 0L);
    }

    public LockModel(String jobIndexName, String jobId, Instant lockTime, long lockDurationSeconds, boolean released, long seqNo, long primaryTerm) {
        this.lockId = jobIndexName + LOCK_ID_DELIMITR + jobId;
        this.jobIndexName = jobIndexName;
        this.jobId = jobId;
        this.lockTime = lockTime;
        this.lockDurationSeconds = lockDurationSeconds;
        this.released = released;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public static String generateLockId(String jobIndexName, String jobId) {
        return jobIndexName + LOCK_ID_DELIMITR + jobId;
    }

    public static LockModel parse(XContentParser parser, long seqNo, long primaryTerm) throws IOException {
        String jobIndexName = null;
        String jobId = null;
        Instant lockTime = null;
        Long lockDurationSecond = null;
        Boolean released = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "job_index_name": {
                    jobIndexName = parser.text();
                    continue block14;
                }
                case "job_id": {
                    jobId = parser.text();
                    continue block14;
                }
                case "lock_time": {
                    lockTime = Instant.ofEpochSecond(parser.longValue());
                    continue block14;
                }
                case "lock_duration_seconds": {
                    lockDurationSecond = parser.longValue();
                    continue block14;
                }
                case "released": {
                    released = parser.booleanValue();
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
        return new LockModel(Objects.requireNonNull(jobIndexName, "JobIndexName cannot be null"), Objects.requireNonNull(jobId, "JobId cannot be null"), Objects.requireNonNull(lockTime, "lockTime cannot be null"), (Long)Objects.requireNonNull(lockDurationSecond, "lockDurationSeconds cannot be null"), Objects.requireNonNull(released, "released cannot be null"), seqNo, primaryTerm);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(JOB_INDEX_NAME, this.jobIndexName).field(JOB_ID, this.jobId).field(LOCK_TIME, this.lockTime.getEpochSecond()).field(LOCK_DURATION, this.lockDurationSeconds).field(RELEASED, this.released).endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
            builder.humanReadable(true);
            this.toXContent(builder, EMPTY_PARAMS);
            return BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e) {
            try {
                XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
                builder.startObject();
                builder.field("error", "error building toString out of XContent: " + e.getMessage());
                builder.field("stack_trace", ExceptionsHelper.stackTrace((Throwable)e));
                builder.endObject();
                return BytesReference.bytes((XContentBuilder)builder).utf8ToString();
            }
            catch (IOException e2) {
                throw new SkyliteException("cannot generate error message for deserialization", (Throwable)e, new Object[0]);
            }
        }
    }

    public String getLockId() {
        return this.lockId;
    }

    public String getJobIndexName() {
        return this.jobIndexName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Instant getLockTime() {
        return this.lockTime;
    }

    public long getLockDurationSeconds() {
        return this.lockDurationSeconds;
    }

    public boolean isReleased() {
        return this.released;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean isExpired() {
        return this.lockTime.getEpochSecond() + this.lockDurationSeconds < Instant.now().getEpochSecond();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockModel lockModel = (LockModel)o;
        return this.lockDurationSeconds == lockModel.lockDurationSeconds && this.released == lockModel.released && this.seqNo == lockModel.seqNo && this.primaryTerm == lockModel.primaryTerm && this.lockId.equals(lockModel.lockId) && this.jobIndexName.equals(lockModel.jobIndexName) && this.jobId.equals(lockModel.jobId) && this.lockTime.equals(lockModel.lockTime);
    }

    public int hashCode() {
        return Objects.hash(this.lockId, this.jobIndexName, this.jobId, this.lockTime, this.lockDurationSeconds, this.released, this.seqNo, this.primaryTerm);
    }
}

