/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.jobs.schedule;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.cronutils.utils.VisibleForTesting;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.jobs.schedule.Schedule;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;

public class CronSchedule
implements Schedule {
    static final String CRON_FIELD = "cron";
    static final String EXPRESSION_FIELD = "expression";
    static final String TIMEZONE_FIELD = "timezone";
    private static CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));
    private ZoneId timezone;
    private String expression;
    private ExecutionTime executionTime;
    private Clock clock;
    private Long scheduleDelay;

    public CronSchedule(String expression, ZoneId timezone) {
        this.expression = expression;
        this.timezone = timezone;
        this.executionTime = ExecutionTime.forCron((Cron)cronParser.parse(this.expression));
        this.clock = Clock.system(timezone);
    }

    public CronSchedule(String expression, ZoneId timezone, long scheduleDelay) {
        this(expression, timezone);
        this.scheduleDelay = scheduleDelay;
    }

    public CronSchedule(StreamInput input) throws IOException {
        this.timezone = input.readZoneId();
        this.expression = input.readString();
        this.scheduleDelay = input.readOptionalLong();
        this.executionTime = ExecutionTime.forCron((Cron)cronParser.parse(this.expression));
        this.clock = Clock.system(this.timezone);
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    @VisibleForTesting
    void setExecutionTime(ExecutionTime executionTime) {
        this.executionTime = executionTime;
    }

    public ZoneId getTimeZone() {
        return this.timezone;
    }

    public String getCronExpression() {
        return this.expression;
    }

    @Override
    public Long getDelay() {
        return this.scheduleDelay;
    }

    @Override
    public Instant getNextExecutionTime(Instant time) {
        Instant baseTime = time == null ? this.clock.instant() : time;
        long delay = this.scheduleDelay == null ? 0L : this.scheduleDelay;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(baseTime.minusMillis(delay), this.timezone);
        ZonedDateTime nextExecutionTime = this.executionTime.nextExecution(zonedDateTime).orElse(null);
        return nextExecutionTime == null ? null : nextExecutionTime.toInstant().plusMillis(delay);
    }

    @Override
    public Duration nextTimeToExecute() {
        long delay = this.scheduleDelay == null ? 0L : this.scheduleDelay;
        Instant now = this.clock.instant().minusMillis(delay);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(now, this.timezone);
        Optional timeToNextExecution = this.executionTime.timeToNextExecution(zonedDateTime);
        return timeToNextExecution.orElse(null);
    }

    @Override
    public Tuple<Instant, Instant> getPeriodStartingAt(Instant startTime) {
        Instant realStartTime;
        long delay;
        long l = delay = this.scheduleDelay == null ? 0L : this.scheduleDelay;
        if (startTime != null) {
            realStartTime = startTime;
        } else {
            Instant now = this.clock.instant();
            Optional lastExecutionTime = this.executionTime.lastExecution(ZonedDateTime.ofInstant(now.minusMillis(delay), this.timezone));
            if (!lastExecutionTime.isPresent()) {
                return new Tuple((Object)now, (Object)now);
            }
            realStartTime = ((ZonedDateTime)lastExecutionTime.get()).toInstant().plusMillis(delay);
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realStartTime.minusMillis(delay), this.timezone);
        ZonedDateTime newEndTime = this.executionTime.nextExecution(zonedDateTime).orElse(null);
        return new Tuple((Object)realStartTime, newEndTime == null ? null : newEndTime.toInstant().plusMillis(delay));
    }

    @Override
    public Boolean runningOnTime(Instant lastExecutionTime) {
        long delay;
        long l = delay = this.scheduleDelay == null ? 0L : this.scheduleDelay;
        if (lastExecutionTime == null) {
            return true;
        }
        Instant now = this.clock.instant().minusMillis(delay);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(now, this.timezone);
        Optional expectedExecutionTime = this.executionTime.lastExecution(zonedDateTime);
        if (!expectedExecutionTime.isPresent()) {
            return false;
        }
        ZonedDateTime actualExecutionTime = ZonedDateTime.ofInstant(lastExecutionTime, this.timezone);
        return ChronoUnit.SECONDS.between(((ZonedDateTime)expectedExecutionTime.get()).plus(delay, ChronoUnit.MILLIS), actualExecutionTime) == 0L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.scheduleDelay == null ? this.toXContentNoDelay(builder) : this.toXContentWithDelay(builder);
    }

    private XContentBuilder toXContentNoDelay(XContentBuilder builder) throws IOException {
        builder.startObject().startObject(CRON_FIELD).field(EXPRESSION_FIELD, this.expression).field(TIMEZONE_FIELD, this.timezone.getId()).endObject().endObject();
        return builder;
    }

    private XContentBuilder toXContentWithDelay(XContentBuilder builder) throws IOException {
        builder.startObject().startObject(CRON_FIELD).field(EXPRESSION_FIELD, this.expression).field(TIMEZONE_FIELD, this.timezone.getId()).field("schedule_delay", this.scheduleDelay).endObject().endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this, (boolean)false, (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronSchedule cronSchedule = (CronSchedule)o;
        return this.timezone.equals(cronSchedule.timezone) && this.expression.equals(cronSchedule.expression) && Objects.equals(this.scheduleDelay, cronSchedule.scheduleDelay);
    }

    public int hashCode() {
        return this.scheduleDelay == null ? Objects.hash(this.timezone, this.expression) : Objects.hash(this.timezone, this.expression, this.scheduleDelay);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeZoneId(this.timezone);
        out.writeString(this.expression);
        out.writeOptionalLong(this.scheduleDelay);
    }
}

