/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.tribuo.CategoricalInfo;
import org.tribuo.RealIDInfo;
import org.tribuo.RealInfo;
import org.tribuo.VariableIDInfo;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.core.CategoricalIDInfoProto;

@ProtoSerializableClass(version=0, serializedDataClass=CategoricalIDInfoProto.class)
public class CategoricalIDInfo
extends CategoricalInfo
implements VariableIDInfo {
    private static final long serialVersionUID = 2L;
    public static final int CURRENT_VERSION = 0;
    @ProtoSerializableField
    private final int id;

    public CategoricalIDInfo(CategoricalInfo info, int id) {
        super(info);
        if (id < 0) {
            throw new IllegalArgumentException("Invalid id number, must be non-negative, found " + id);
        }
        this.id = id;
    }

    private CategoricalIDInfo(CategoricalIDInfo info, String newName) {
        super(info, newName);
        this.id = info.id;
    }

    private CategoricalIDInfo(String name, int id) {
        super(name);
        if (id < 0) {
            throw new IllegalArgumentException("Invalid id number, must be non-negative, found " + id);
        }
        this.id = id;
    }

    public static CategoricalIDInfo deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        CategoricalIDInfoProto proto = (CategoricalIDInfoProto)message.unpack(CategoricalIDInfoProto.class);
        CategoricalIDInfo info = new CategoricalIDInfo(proto.getName(), proto.getId());
        List<Double> keys = proto.getKeyList();
        List<Long> values = proto.getValueList();
        if (keys.size() != values.size()) {
            throw new IllegalStateException("Invalid protobuf, keys and values don't match. keys.size() = " + keys.size() + ", values.size() = " + values.size());
        }
        int newCount = 0;
        if (keys.size() > 1) {
            info.valueCounts = new HashMap(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                if (values.get(i) < 0L) {
                    throw new IllegalStateException("Invalid protobuf, counts must be positive, found " + values.get(i) + " for value " + keys.get(i));
                }
                info.valueCounts.put(keys.get(i), new MutableLong((Number)values.get(i)));
                newCount += values.get(i).intValue();
            }
        } else {
            info.observedValue = proto.getObservedValue();
            info.observedCount = proto.getObservedCount();
            newCount = (int)proto.getObservedCount();
            if (info.observedCount < 0L) {
                throw new IllegalStateException("Invalid protobuf, counts must be positive, found " + info.observedCount + " for value " + info.observedValue);
            }
        }
        if (newCount != proto.getCount()) {
            throw new IllegalStateException("Invalid protobuf, count " + newCount + " did not match expected value " + proto.getCount());
        }
        info.count = newCount;
        return info;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public RealIDInfo generateRealInfo() {
        RealInfo realInfo = super.generateRealInfo();
        return new RealIDInfo(realInfo, this.id);
    }

    @Override
    public CategoricalIDInfo copy() {
        return new CategoricalIDInfo(this, this.name);
    }

    @Override
    public CategoricalIDInfo makeIDInfo(int id) {
        return new CategoricalIDInfo((CategoricalInfo)this, id);
    }

    @Override
    public CategoricalIDInfo rename(String newName) {
        return new CategoricalIDInfo(this, newName);
    }

    @Override
    public String toString() {
        if (this.valueCounts != null) {
            return "CategoricalFeature(name=" + this.name + ",id=" + this.id + ",count=" + this.count + ",map=" + this.valueCounts.toString() + ")";
        }
        return "CategoricalFeature(name=" + this.name + ",id=" + this.id + ",count=" + this.count + ",map={" + this.observedValue + "," + this.observedCount + "})";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoricalIDInfo that = (CategoricalIDInfo)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

