/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import com.oracle.labs.mlrg.olcut.util.MutableNumber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.stream.Collectors;
import org.tribuo.CategoricalIDInfo;
import org.tribuo.RealInfo;
import org.tribuo.SkeletalVariableInfo;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoSerializableKeysValuesField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.CategoricalInfoProto;
import org.tribuo.protos.core.VariableInfoProto;
import org.tribuo.util.Util;

@ProtoSerializableClass(version=0, serializedDataClass=CategoricalInfoProto.class)
public class CategoricalInfo
extends SkeletalVariableInfo {
    private static final long serialVersionUID = 2L;
    public static final int CURRENT_VERSION = 0;
    private static final MutableLong ZERO = new MutableLong(0L);
    public static final int THRESHOLD = 50;
    private static final double COMPARISON_THRESHOLD = 1.0E-10;
    @ProtoSerializableKeysValuesField(keysName="key", valuesName="value")
    protected Map<Double, MutableLong> valueCounts = null;
    @ProtoSerializableField
    protected double observedValue = Double.NaN;
    @ProtoSerializableField
    protected long observedCount = 0L;
    protected transient double[] values = null;
    protected transient long totalObservations = -1L;
    protected transient double[] cdf = null;

    public CategoricalInfo(String name) {
        super(name);
    }

    protected CategoricalInfo(CategoricalInfo info) {
        this(info, info.name);
    }

    protected CategoricalInfo(CategoricalInfo info, String newName) {
        super(newName, info.count);
        if (info.valueCounts != null) {
            this.valueCounts = MutableNumber.copyMap(info.valueCounts);
        } else {
            this.observedValue = info.observedValue;
            this.observedCount = info.observedCount;
        }
    }

    public static CategoricalInfo deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        CategoricalInfoProto proto = (CategoricalInfoProto)message.unpack(CategoricalInfoProto.class);
        CategoricalInfo info = new CategoricalInfo(proto.getName());
        List<Double> keys = proto.getKeyList();
        List<Long> values = proto.getValueList();
        if (keys.size() != values.size()) {
            throw new IllegalStateException("Invalid protobuf, keys and values don't match. keys.size() = " + keys.size() + ", values.size() = " + values.size());
        }
        int newCount = 0;
        if (keys.size() > 1) {
            info.valueCounts = new HashMap<Double, MutableLong>(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                if (values.get(i) < 0L) {
                    throw new IllegalStateException("Invalid protobuf, counts must be positive, found " + values.get(i) + " for value " + keys.get(i));
                }
                info.valueCounts.put(keys.get(i), new MutableLong((Number)values.get(i)));
                newCount += values.get(i).intValue();
            }
        } else {
            info.observedValue = proto.getObservedValue();
            info.observedCount = proto.getObservedCount();
            newCount = (int)proto.getObservedCount();
            if (info.observedCount < 0L) {
                throw new IllegalStateException("Invalid protobuf, counts must be positive, found " + info.observedCount + " for value " + info.observedValue);
            }
        }
        info.count = newCount;
        return info;
    }

    @Override
    public VariableInfoProto serialize() {
        return (VariableInfoProto)ProtoUtil.serialize(this);
    }

    @Override
    protected void observe(double value) {
        if (value != 0.0) {
            super.observe(value);
            if (this.valueCounts != null) {
                MutableLong count = this.valueCounts.computeIfAbsent(value, k -> new MutableLong());
                count.increment();
            } else if (Double.isNaN(this.observedValue)) {
                this.observedValue = value;
                ++this.observedCount;
            } else if (Math.abs(value - this.observedValue) < 1.0E-10) {
                ++this.observedCount;
            } else {
                this.valueCounts = new HashMap<Double, MutableLong>(4);
                this.valueCounts.put(this.observedValue, new MutableLong(this.observedCount));
                this.valueCounts.put(value, new MutableLong(1L));
                this.observedValue = Double.NaN;
                this.observedCount = 0L;
            }
            this.values = null;
        }
    }

    public long getObservationCount(double value) {
        if (this.valueCounts != null) {
            return this.valueCounts.getOrDefault(value, ZERO).longValue();
        }
        if (Math.abs(value - this.observedValue) < 1.0E-10) {
            return this.observedCount;
        }
        return 0L;
    }

    public int getUniqueObservations() {
        if (this.valueCounts != null) {
            return this.valueCounts.size();
        }
        if (Double.isNaN(this.observedValue)) {
            return 0;
        }
        return 1;
    }

    public RealInfo generateRealInfo() {
        double mean;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        double sumSquares = 0.0;
        if (this.valueCounts != null) {
            double valCount;
            double value;
            List entries = this.valueCounts.entrySet().stream().sorted(Comparator.comparingDouble(Map.Entry::getKey)).collect(Collectors.toList());
            for (Map.Entry e : entries) {
                value = (Double)e.getKey();
                valCount = ((MutableLong)e.getValue()).longValue();
                if (value > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
                sum += value * valCount;
            }
            mean = sum / (double)this.count;
            for (Map.Entry e : entries) {
                value = (Double)e.getKey();
                valCount = ((MutableLong)e.getValue()).longValue();
                sumSquares += (value - mean) * (value - mean) * valCount;
            }
        } else {
            min = this.observedValue;
            max = this.observedValue;
            mean = this.observedValue;
            sumSquares = 0.0;
        }
        return new RealInfo(this.name, this.count, max, min, mean, sumSquares);
    }

    @Override
    public CategoricalInfo copy() {
        return new CategoricalInfo(this);
    }

    @Override
    public CategoricalIDInfo makeIDInfo(int id) {
        return new CategoricalIDInfo(this, id);
    }

    @Override
    public CategoricalInfo rename(String newName) {
        return new CategoricalInfo(this, newName);
    }

    @Override
    public synchronized double uniformSample(SplittableRandom rng) {
        if (this.values == null) {
            this.regenerateValues();
        }
        int sampleIdx = rng.nextInt(this.values.length);
        return this.values[sampleIdx];
    }

    public double frequencyBasedSample(SplittableRandom rng, long totalObservations) {
        if (totalObservations != this.totalObservations || this.cdf == null) {
            this.regenerateCDF(totalObservations);
        }
        int lookup = Util.sampleFromCDF(this.cdf, rng);
        return this.values[lookup];
    }

    public double frequencyBasedSample(Random rng, long totalObservations) {
        if (totalObservations != this.totalObservations || this.cdf == null) {
            this.regenerateCDF(totalObservations);
        }
        int lookup = Util.sampleFromCDF(this.cdf, rng);
        return this.values[lookup];
    }

    public double[] getValues() {
        if (this.values == null) {
            this.regenerateValues();
        }
        return Arrays.copyOf(this.values, this.values.length);
    }

    private synchronized void regenerateCDF(long newTotalObservations) {
        long[] counts;
        if (this.valueCounts != null) {
            if (this.valueCounts.containsKey(0.0)) {
                this.values = new double[this.valueCounts.size()];
                counts = new long[this.valueCounts.size()];
            } else {
                this.values = new double[this.valueCounts.size() + 1];
                counts = new long[this.valueCounts.size() + 1];
            }
            this.values[0] = 0.0;
            counts[0] = newTotalObservations;
            int counter = 1;
            long total = 0L;
            List entries = this.valueCounts.entrySet().stream().sorted(Comparator.comparingDouble(Map.Entry::getKey)).collect(Collectors.toList());
            for (Map.Entry e : entries) {
                if ((Double)e.getKey() == 0.0) continue;
                this.values[counter] = (Double)e.getKey();
                counts[counter] = ((MutableLong)e.getValue()).longValue();
                total += counts[counter];
                ++counter;
            }
            counts[0] = counts[0] - total;
        } else if (Double.isNaN(this.observedValue) || this.observedValue == 0.0) {
            this.values = new double[1];
            counts = new long[1];
            this.values[0] = 0.0;
            counts[0] = newTotalObservations;
        } else {
            this.values = new double[2];
            counts = new long[2];
            this.values[0] = 0.0;
            counts[0] = newTotalObservations - this.observedCount;
            this.values[1] = this.observedValue;
            counts[1] = this.observedCount;
        }
        long sum = 0L;
        for (int i = 0; i < counts.length; ++i) {
            sum += counts[i];
        }
        if (sum != newTotalObservations) {
            throw new IllegalStateException("Total counts = " + sum + ", supplied value = " + newTotalObservations);
        }
        this.cdf = Util.generateCDF(counts, sum);
        this.totalObservations = newTotalObservations;
    }

    private synchronized void regenerateValues() {
        if (this.valueCounts != null) {
            int counter;
            if (this.valueCounts.containsKey(0.0)) {
                this.values = new double[this.valueCounts.size()];
                counter = 0;
            } else {
                this.values = new double[this.valueCounts.size() + 1];
                this.values[0] = 0.0;
                counter = 1;
            }
            for (Double key : this.valueCounts.keySet().stream().sorted().collect(Collectors.toList())) {
                this.values[counter] = key;
                ++counter;
            }
        } else if (Double.isNaN(this.observedValue) || this.observedValue == 0.0) {
            this.values = new double[1];
            this.values[0] = 0.0;
        } else {
            this.values = new double[2];
            this.values[0] = 0.0;
            this.values[1] = this.observedValue;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoricalInfo that = (CategoricalInfo)o;
        if (this.valueCounts != null ^ that.valueCounts != null) {
            return false;
        }
        if (this.valueCounts != null && that.valueCounts != null) {
            if (this.valueCounts.size() != that.valueCounts.size()) {
                return false;
            }
            for (Map.Entry<Double, MutableLong> e : this.valueCounts.entrySet()) {
                MutableLong other = that.valueCounts.get(e.getKey());
                if (other != null && e.getValue().longValue() == other.longValue()) continue;
                return false;
            }
        }
        return Double.compare(that.observedValue, this.observedValue) == 0 && this.observedCount == that.observedCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.valueCounts, this.observedValue, this.observedCount);
    }

    @Override
    public String toString() {
        if (this.valueCounts != null) {
            return "CategoricalFeature(name=" + this.name + ",count=" + this.count + ",map=" + this.valueCounts.toString() + ")";
        }
        return "CategoricalFeature(name=" + this.name + ",count=" + this.count + ",map={" + this.observedValue + "," + this.observedCount + "})";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.totalObservations = -1L;
        this.values = null;
        this.cdf = null;
    }
}

