/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tribuo.DataSource;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.impl.DatasetDataCarrier;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.DatasetProto;
import org.tribuo.protos.core.ExampleProto;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.transform.TransformStatistics;
import org.tribuo.transform.Transformation;
import org.tribuo.transform.TransformationMap;
import org.tribuo.transform.Transformer;
import org.tribuo.transform.TransformerMap;
import org.tribuo.util.Util;

public abstract class Dataset<T extends Output<T>>
implements Iterable<Example<T>>,
ProtoSerializable<DatasetProto>,
Provenancable<DatasetProvenance>,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger(Dataset.class.getName());
    private static final SplittableRandom rng = new SplittableRandom(12345L);
    protected final List<Example<T>> data = new ArrayList<Example<T>>();
    protected final DataProvenance sourceProvenance;
    protected final OutputFactory<T> outputFactory;
    protected final String tribuoVersion;
    protected int[] indices = null;

    protected Dataset(DataProvenance provenance, OutputFactory<T> outputFactory) {
        this(provenance, outputFactory, "4.3.1");
    }

    protected Dataset(DataProvenance provenance, OutputFactory<T> outputFactory, String tribuoVersion) {
        this.sourceProvenance = provenance;
        this.outputFactory = outputFactory;
        this.tribuoVersion = tribuoVersion;
    }

    protected Dataset(DataSource<T> dataSource) {
        this((DataProvenance)dataSource.getProvenance(), dataSource.getOutputFactory());
    }

    public static Dataset<?> deserialize(DatasetProto datasetProto) {
        return (Dataset)ProtoUtil.deserialize(datasetProto);
    }

    public static Dataset<?> deserializeFromFile(Path path) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            Dataset<?> dataset = Dataset.deserializeFromStream(is);
            return dataset;
        }
    }

    public static Dataset<?> deserializeFromStream(InputStream is) throws IOException {
        DatasetProto proto = DatasetProto.parseFrom(is);
        return Dataset.deserialize(proto);
    }

    public void serializeToFile(Path path) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            this.serializeToStream(os);
        }
    }

    public void serializeToStream(OutputStream stream) throws IOException {
        DatasetProto proto = (DatasetProto)this.serialize();
        proto.writeTo(stream);
    }

    public String getSourceDescription() {
        return "Dataset(source=" + this.sourceProvenance.toString() + ")";
    }

    public DataProvenance getSourceProvenance() {
        return this.sourceProvenance;
    }

    public List<Example<T>> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    public abstract Set<T> getOutputs();

    public Example<T> getExample(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Example index " + index + " is out of bounds.");
        }
        return this.data.get(index);
    }

    public int size() {
        return this.data.size();
    }

    public synchronized void shuffle(boolean shuffle) {
        this.indices = (int[])(shuffle ? Util.randperm(this.data.size(), rng) : null);
    }

    public abstract ImmutableOutputInfo<T> getOutputIDInfo();

    public abstract OutputInfo<T> getOutputInfo();

    public abstract ImmutableFeatureMap getFeatureIDMap();

    public abstract FeatureMap getFeatureMap();

    @Override
    public synchronized Iterator<Example<T>> iterator() {
        if (this.indices == null) {
            return this.data.iterator();
        }
        return new ShuffleIterator(this, this.indices);
    }

    public String toString() {
        return "Dataset(source=" + this.sourceProvenance + ")";
    }

    public TransformerMap createTransformers(TransformationMap transformations) {
        return this.createTransformers(transformations, false);
    }

    /*
     * WARNING - void declaration
     */
    public TransformerMap createTransformers(TransformationMap transformations, boolean includeImplicitZeroFeatures) {
        ArrayList<String> featureNames = new ArrayList<String>(this.getFeatureMap().keySet());
        logger.fine(String.format("Processing %d feature specific transforms", transformations.getFeatureTransformations().size()));
        HashMap<String, List<Transformation>> featureTransformations = new HashMap<String, List<Transformation>>();
        for (Map.Entry<String, List<Transformation>> entry : transformations.getFeatureTransformations().entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            for (String name : featureNames) {
                Object oldTransformations;
                if (!pattern.matcher(name).matches() || (oldTransformations = featureTransformations.put(name, entry.getValue())) == null) continue;
                throw new IllegalArgumentException("Feature name '" + name + "' matches multiple regexes, at least one of which was '" + entry.getKey() + "'.");
            }
        }
        HashMap<String, Queue> featureStats = new HashMap<String, Queue>();
        HashMap<String, MutableLong> sparseCount = new HashMap<String, MutableLong>();
        for (Map.Entry entry : featureTransformations.entrySet()) {
            LinkedList<TransformStatistics> l = new LinkedList<TransformStatistics>();
            for (Transformation transformation : (List)entry.getValue()) {
                l.add(transformation.createStats());
            }
            featureStats.put((String)entry.getKey(), l);
            sparseCount.put((String)entry.getKey(), new MutableLong((long)this.data.size()));
        }
        if (!transformations.getGlobalTransformations().isEmpty()) {
            int ntransform = featureNames.size();
            logger.fine(String.format("Starting %,d global transformations", ntransform));
            boolean bl = false;
            for (String v : featureNames) {
                void var8_14;
                Queue queue = featureStats.computeIfAbsent(v, k -> new LinkedList());
                for (Transformation t : transformations.getGlobalTransformations()) {
                    queue.add(t.createStats());
                }
                featureStats.put(v, queue);
                sparseCount.putIfAbsent(v, new MutableLong((long)this.data.size()));
                if (!logger.isLoggable(Level.FINE) || ++var8_14 % 10000 != false) continue;
                logger.fine(String.format("Completed %,d of %,d global transformations", (int)var8_14, ntransform));
            }
        }
        LinkedHashMap<String, List<Transformer>> output = new LinkedHashMap<String, List<Transformer>>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        boolean initialisedSparseCounts = false;
        while (!featureStats.isEmpty()) {
            for (Example<T> example : this.data) {
                for (Feature f : example) {
                    if (!featureStats.containsKey(f.getName())) continue;
                    if (!initialisedSparseCounts) {
                        ((MutableLong)sparseCount.get(f.getName())).decrement();
                    }
                    List curTransformers = (List)output.get(f.getName());
                    double fValue = TransformerMap.applyTransformerList(f.getValue(), curTransformers);
                    ((TransformStatistics)((Queue)featureStats.get(f.getName())).peek()).observeValue(fValue);
                }
            }
            initialisedSparseCounts = true;
            linkedHashSet.clear();
            for (Map.Entry entry : featureStats.entrySet()) {
                TransformStatistics currentStats = (TransformStatistics)((Queue)entry.getValue()).poll();
                if (includeImplicitZeroFeatures) {
                    int unobservedFeatures = ((MutableLong)sparseCount.get(entry.getKey())).intValue();
                    currentStats.observeSparse(unobservedFeatures);
                }
                List l = output.computeIfAbsent((String)entry.getKey(), k -> new ArrayList());
                l.add(currentStats.generateTransformer());
                if (!((Queue)entry.getValue()).isEmpty()) continue;
                linkedHashSet.add((String)entry.getKey());
            }
            for (String string : linkedHashSet) {
                featureStats.remove(string);
            }
        }
        return new TransformerMap(output, (DatasetProvenance)this.getProvenance(), transformations.getProvenance());
    }

    protected DatasetDataCarrier<T> createDataCarrier(FeatureMap featureMap, OutputInfo<T> outputInfo) {
        return this.createDataCarrier(featureMap, outputInfo, Collections.emptyList());
    }

    protected DatasetDataCarrier<T> createDataCarrier(FeatureMap featureMap, OutputInfo<T> outputInfo, List<ObjectProvenance> transformationProvenances) {
        String version = this.tribuoVersion == null ? "4.3.1" : this.tribuoVersion;
        return new DatasetDataCarrier<T>(this.sourceProvenance, featureMap, outputInfo, this.outputFactory, transformationProvenances, version);
    }

    public boolean validate(Class<? extends Output<?>> clazz) {
        Set<T> domain = this.getOutputInfo().getDomain();
        boolean output = true;
        for (Output type : domain) {
            output &= clazz.isInstance(type);
        }
        return output;
    }

    public static <T extends Output<T>> Dataset<T> castDataset(Dataset<?> inputDataset, Class<T> outputType) {
        if (inputDataset.validate(outputType)) {
            Dataset<?> castedModel = inputDataset;
            return castedModel;
        }
        throw new ClassCastException("Attempted to cast dataset to " + outputType.getName() + " which is not valid for dataset " + inputDataset.toString());
    }

    protected static List<Example<?>> deserializeExamples(List<ExampleProto> examplesList, Class<?> outputClass, FeatureMap fmap) {
        ArrayList examples = new ArrayList();
        for (ExampleProto e : examplesList) {
            Example<?> example = Example.deserialize(e);
            if (example.getOutput().getClass().equals(outputClass)) {
                for (Feature f : example) {
                    if (fmap.get(f.getName()) != null) continue;
                    throw new IllegalStateException("Invalid protobuf, feature domain does not contain feature " + f.getName() + " present in an example");
                }
                examples.add(example);
                continue;
            }
            throw new IllegalStateException("Invalid protobuf, expected all examples to have output class " + outputClass + ", but found " + example.getOutput().getClass());
        }
        return examples;
    }

    private static class ShuffleIterator<T extends Output<T>>
    implements Iterator<Example<T>> {
        private final Dataset<T> data;
        private final int[] indices;
        private int index;

        public ShuffleIterator(Dataset<T> data, int[] indices) {
            this.data = data;
            this.indices = indices;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.indices.length;
        }

        @Override
        public Example<T> next() {
            Example<T> e = this.data.getExample(this.indices[this.index]);
            ++this.index;
            return e;
        }
    }
}

