/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.Output;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.ExampleProto;
import org.tribuo.transform.Transformer;
import org.tribuo.transform.TransformerMap;
import org.tribuo.util.Merger;

public abstract class Example<T extends Output<T>>
implements Iterable<Feature>,
ProtoSerializable<ExampleProto>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_METADATA_SIZE = 2;
    public static final float DEFAULT_WEIGHT = 1.0f;
    public static final String NAME = "name";
    protected final T output;
    protected float weight = 1.0f;
    protected Map<String, Object> metadata = null;

    protected Example(T output, float weight, Map<String, Object> metadata) {
        this.output = output;
        this.weight = weight;
        this.metadata = metadata != null && !metadata.isEmpty() ? new HashMap<String, Object>(metadata) : null;
    }

    protected Example(T output, float weight) {
        this.output = output;
        this.weight = weight;
    }

    protected Example(T output, Map<String, Object> metadata) {
        this.output = output;
        this.metadata = metadata != null && !metadata.isEmpty() ? new HashMap<String, Object>(metadata) : null;
    }

    protected Example(T output) {
        this.output = output;
    }

    protected Example(Example<T> other) {
        this.output = other.output;
        this.weight = other.weight;
        this.metadata = other.metadata != null && !other.metadata.isEmpty() ? new HashMap<String, Object>(other.metadata) : null;
    }

    public T getOutput() {
        return this.output;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public synchronized Optional<Object> getMetadataValue(String key) {
        if (this.metadata != null) {
            return Optional.ofNullable(this.metadata.get(key));
        }
        return Optional.empty();
    }

    public synchronized void setMetadataValue(String key, Object value) {
        if (this.containsMetadata(key)) {
            Object oldValue = this.metadata.get(key);
            throw new IllegalArgumentException("Example metadata is append only. Key '" + key + "' is already associated with value '" + oldValue + "'");
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>(2);
        }
        this.metadata.put(key, value);
    }

    public boolean containsMetadata(String key) {
        if (this.metadata != null) {
            return this.metadata.containsKey(key);
        }
        return false;
    }

    public Map<String, Object> getMetadata() {
        if (this.metadata != null) {
            return new HashMap<String, Object>(this.metadata);
        }
        return Collections.emptyMap();
    }

    protected abstract void sort();

    public abstract void add(Feature var1);

    public abstract void addAll(Collection<? extends Feature> var1);

    public abstract int size();

    public abstract void removeFeatures(List<Feature> var1);

    public abstract void reduceByName(Merger var1);

    public abstract boolean validateExample();

    public void transform(TransformerMap transformerMap) {
        for (Map.Entry<String, List<Transformer>> e : transformerMap.entrySet()) {
            Feature f = this.lookup(e.getKey());
            if (f == null) continue;
            double value = f.getValue();
            for (Transformer t : e.getValue()) {
                value = t.transform(value);
            }
            this.set(new Feature(f.getName(), value));
        }
    }

    public abstract boolean isDense(FeatureMap var1);

    public void densify(FeatureMap fMap) {
        ArrayList<String> featureNames = new ArrayList<String>(fMap.keySet());
        Collections.sort(featureNames);
        this.densify(featureNames);
    }

    protected abstract void densify(List<String> var1);

    public abstract Example<T> copy();

    public Feature lookup(String i) {
        for (Feature f : this) {
            if (!i.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public abstract void set(Feature var1);

    public abstract void canonicalize(FeatureMap var1);

    public static Example<?> deserialize(ExampleProto proto) {
        return (Example)ProtoUtil.deserialize(proto);
    }
}

