/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.DataSource;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableFeatureMap;
import org.tribuo.MutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.impl.DatasetDataCarrier;
import org.tribuo.protos.core.DatasetProto;
import org.tribuo.protos.core.ExampleProto;
import org.tribuo.protos.core.MutableDatasetProto;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.transform.TransformerMap;

public class MutableDataset<T extends Output<T>>
extends Dataset<T> {
    private static final Logger logger = Logger.getLogger(MutableDataset.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    protected final MutableOutputInfo<T> outputMap;
    protected final MutableFeatureMap featureMap;
    protected final List<ObjectProvenance> transformProvenances = new ArrayList<ObjectProvenance>();
    protected boolean dense = true;

    public MutableDataset(DataProvenance sourceProvenance, OutputFactory<T> outputFactory) {
        super(sourceProvenance, outputFactory);
        this.featureMap = new MutableFeatureMap();
        this.outputMap = outputFactory.generateInfo();
    }

    public MutableDataset(Iterable<Example<T>> dataSource, DataProvenance provenance, OutputFactory<T> outputFactory) {
        super(provenance, outputFactory);
        this.featureMap = new MutableFeatureMap();
        this.outputMap = outputFactory.generateInfo();
        for (Example<T> ex : dataSource) {
            this.add(ex);
        }
    }

    public MutableDataset(DataSource<T> dataSource) {
        this(dataSource, (DataProvenance)dataSource.getProvenance(), dataSource.getOutputFactory());
    }

    private MutableDataset(DataProvenance provenance, OutputFactory<T> factory, String tribuoVersion, MutableFeatureMap fmap, MutableOutputInfo<T> outputInfo, List<Example<T>> examples, boolean dense) {
        super(provenance, factory, tribuoVersion);
        this.featureMap = fmap;
        this.outputMap = outputInfo;
        this.data.addAll(examples);
        this.dense = dense;
    }

    public static MutableDataset<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        MutableDatasetProto proto = (MutableDatasetProto)message.unpack(MutableDatasetProto.class);
        DatasetDataCarrier<?> carrier = DatasetDataCarrier.deserialize(proto.getMetadata());
        Class<?> outputClass = carrier.outputFactory().getUnknownOutput().getClass();
        FeatureMap fmap = carrier.featureDomain();
        List examples = MutableDataset.deserializeExamples(proto.getExamplesList(), outputClass, fmap);
        if (!(fmap instanceof MutableFeatureMap)) {
            throw new IllegalStateException("Invalid protobuf, feature map was not mutable");
        }
        if (!(carrier.outputDomain() instanceof MutableOutputInfo)) {
            throw new IllegalStateException("Invalid protobuf, output info was not mutable");
        }
        return new MutableDataset(carrier.provenance(), carrier.outputFactory(), carrier.tribuoVersion(), (MutableFeatureMap)fmap, (MutableOutputInfo)carrier.outputDomain(), examples, proto.getDense());
    }

    public void add(Example<T> ex) {
        if (!ex.validateExample()) {
            throw new IllegalArgumentException("Example had duplicate features, invalid features or no features.");
        }
        this.outputMap.observe(ex.getOutput());
        this.data.add(ex);
        int oldNumFeatures = this.featureMap.size();
        for (Feature f : ex) {
            this.featureMap.add(f.getName(), f.getValue());
        }
        ex.canonicalize(this.featureMap);
        if (oldNumFeatures != 0 && (oldNumFeatures < this.featureMap.size() || ex.size() != this.featureMap.size())) {
            this.dense = false;
        }
    }

    public void addAll(Collection<? extends Example<T>> collection) {
        for (Example<T> e : collection) {
            this.add(e);
        }
    }

    public void setWeights(Map<T, Float> weights) {
        for (Example e : this) {
            Float weight = weights.get(e.getOutput());
            if (weight != null) {
                e.setWeight(weight.floatValue());
                continue;
            }
            e.setWeight(1.0f);
        }
    }

    @Override
    public Set<T> getOutputs() {
        return this.outputMap.getDomain();
    }

    @Override
    public ImmutableFeatureMap getFeatureIDMap() {
        return new ImmutableFeatureMap(this.featureMap);
    }

    @Override
    public MutableFeatureMap getFeatureMap() {
        return this.featureMap;
    }

    @Override
    public ImmutableOutputInfo<T> getOutputIDInfo() {
        return this.outputMap.generateImmutableOutputInfo();
    }

    @Override
    public OutputInfo<T> getOutputInfo() {
        return this.outputMap;
    }

    @Override
    public String toString() {
        if (this.transformProvenances.isEmpty()) {
            return "MutableDataset(source=" + this.sourceProvenance + ",isDense=" + this.dense + ")";
        }
        return "MutableDataset(source=" + this.sourceProvenance + ",isDense=" + this.dense + ",transforms=" + this.transformProvenances.toString() + ")";
    }

    public boolean isDense() {
        return this.dense;
    }

    public void transform(TransformerMap transformerMap) {
        this.featureMap.clear();
        logger.fine(String.format("Transforming %,d examples", this.data.size()));
        int nt = 0;
        for (Example example : this.data) {
            example.transform(transformerMap);
            for (Feature f : example) {
                this.featureMap.add(f.getName(), f.getValue());
            }
            if (!logger.isLoggable(Level.FINE) || ++nt % 10000 != 0) continue;
            logger.fine(String.format("Transformed %,d/%,d", nt, this.data.size()));
        }
        this.transformProvenances.add(transformerMap.getProvenance());
    }

    public void densify() {
        ArrayList<String> featureNames = new ArrayList<String>(this.featureMap.keySet());
        Collections.sort(featureNames);
        for (Example example : this.data) {
            example.densify(featureNames);
        }
        this.dense = true;
    }

    public void clear() {
        this.outputMap.clear();
        this.featureMap.clear();
        this.data.clear();
        this.transformProvenances.clear();
        this.dense = true;
    }

    public void regenerateOutputInfo() {
        this.outputMap.clear();
        for (Example e : this.data) {
            this.outputMap.observe(e.getOutput());
        }
    }

    public void regenerateFeatureInfo() {
        this.featureMap.clear();
        this.dense = true;
        for (Example e : this.data) {
            int oldNumFeatures = this.featureMap.size();
            for (Feature f : e) {
                this.featureMap.add(f.getName(), f.getValue());
            }
            e.canonicalize(this.featureMap);
            if (oldNumFeatures == 0 || oldNumFeatures >= this.featureMap.size() && e.size() == this.featureMap.size()) continue;
            this.dense = false;
        }
    }

    public DatasetProvenance getProvenance() {
        return new DatasetProvenance(this.sourceProvenance, (ListProvenance<ObjectProvenance>)new ListProvenance(this.transformProvenances), this);
    }

    @Override
    public DatasetProto serialize() {
        MutableDatasetProto.Builder datasetBuilder = MutableDatasetProto.newBuilder();
        datasetBuilder.setDense(this.dense);
        datasetBuilder.setMetadata(this.createDataCarrier(this.featureMap, this.outputMap, this.transformProvenances).serialize());
        for (Example e : this.data) {
            datasetBuilder.addExamples((ExampleProto)e.serialize());
        }
        DatasetProto.Builder builder = DatasetProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(MutableDataset.class.getName());
        builder.setSerializedData(Any.pack((Message)datasetBuilder.build()));
        return builder.build();
    }

    public static <T extends Output<T>> MutableDataset<T> createDeepCopy(Dataset<T> other) {
        MutableDataset<T> copy = new MutableDataset<T>((DataProvenance)other.getProvenance(), other.outputFactory);
        for (Example<T> e : other) {
            copy.add(e.copy());
        }
        return copy;
    }
}

