/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.tribuo.CategoricalInfo;
import org.tribuo.FeatureMap;
import org.tribuo.SkeletalVariableInfo;
import org.tribuo.VariableInfo;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.FeatureDomainProto;
import org.tribuo.protos.core.MutableFeatureMapProto;
import org.tribuo.protos.core.VariableInfoProto;

@ProtoSerializableClass(version=0, serializedDataClass=MutableFeatureMapProto.class)
public class MutableFeatureMap
extends FeatureMap {
    private static final long serialVersionUID = 2L;
    public static final int CURRENT_VERSION = 0;
    @ProtoSerializableField
    private final boolean convertHighCardinality;

    public MutableFeatureMap() {
        this(true);
    }

    public MutableFeatureMap(boolean convertHighCardinality) {
        this.convertHighCardinality = convertHighCardinality;
    }

    public static MutableFeatureMap deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        MutableFeatureMapProto proto = (MutableFeatureMapProto)message.unpack(MutableFeatureMapProto.class);
        MutableFeatureMap obj = new MutableFeatureMap(proto.getConvertHighCardinality());
        for (VariableInfoProto infoProto : proto.getInfoList()) {
            VariableInfo info = (VariableInfo)ProtoUtil.deserialize(infoProto);
            VariableInfo o = obj.put(info);
            if (o == null) continue;
            throw new IllegalStateException("Invalid protobuf, found two mappings for " + info.getName());
        }
        return obj;
    }

    @Override
    public FeatureDomainProto serialize() {
        return (FeatureDomainProto)ProtoUtil.serialize(this);
    }

    public VariableInfo put(VariableInfo info) {
        VariableInfo old = this.m.put(info.getName(), info);
        return old;
    }

    public void add(String name, double value) {
        CategoricalInfo cInfo;
        SkeletalVariableInfo info = (SkeletalVariableInfo)this.m.computeIfAbsent(name, CategoricalInfo::new);
        info.observe(value);
        if (this.convertHighCardinality && info instanceof CategoricalInfo && (cInfo = (CategoricalInfo)info).getUniqueObservations() > 50) {
            this.m.put(name, cInfo.generateRealInfo());
        }
    }

    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MutableFeatureMap that = (MutableFeatureMap)o;
        return this.convertHighCardinality == that.convertHighCardinality;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.convertHighCardinality);
    }
}

