/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.tribuo.RealInfo;
import org.tribuo.VariableIDInfo;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.core.RealIDInfoProto;

@ProtoSerializableClass(version=0, serializedDataClass=RealIDInfoProto.class)
public class RealIDInfo
extends RealInfo
implements VariableIDInfo {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @ProtoSerializableField
    private final int id;

    public RealIDInfo(String name, int count, double max, double min, double mean, double sumSquares, int id) {
        super(name, count, max, min, mean, sumSquares);
        if (id < 0) {
            throw new IllegalArgumentException("Invalid id number, must be non-negative, found " + id);
        }
        this.id = id;
    }

    public RealIDInfo(RealInfo info, int id) {
        super(info);
        if (id < 0) {
            throw new IllegalArgumentException("Invalid id number, must be non-negative, found " + id);
        }
        this.id = id;
    }

    private RealIDInfo(RealIDInfo info, String newName) {
        super(info, newName);
        this.id = info.id;
    }

    public static RealIDInfo deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        RealIDInfoProto proto = (RealIDInfoProto)message.unpack(RealIDInfoProto.class);
        if (proto.getId() < 0) {
            throw new IllegalStateException("Invalid protobuf, found no id where one was expected.");
        }
        RealIDInfo info = new RealIDInfo(proto.getName(), proto.getCount(), proto.getMax(), proto.getMin(), proto.getMean(), proto.getSumSquares(), proto.getId());
        return info;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public RealIDInfo makeIDInfo(int id) {
        return new RealIDInfo((RealInfo)this, id);
    }

    @Override
    public RealIDInfo rename(String newName) {
        return new RealIDInfo(this, newName);
    }

    @Override
    public RealIDInfo copy() {
        return new RealIDInfo(this, this.name);
    }

    @Override
    public String toString() {
        return String.format("RealFeature(name=%s,id=%d,count=%d,max=%f,min=%f,mean=%f,variance=%f)", this.name, this.id, this.count, this.max, this.min, this.mean, this.sumSquares / (double)(this.count - 1));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealIDInfo that = (RealIDInfo)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

