/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.FeatureSetProto;
import org.tribuo.protos.core.SelectedFeatureSetProto;
import org.tribuo.provenance.FeatureSetProvenance;

@ProtoSerializableClass(serializedDataClass=SelectedFeatureSetProto.class, version=0)
public final class SelectedFeatureSet
implements ProtoSerializable<FeatureSetProto>,
Provenancable<FeatureSetProvenance>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @ProtoSerializableField
    private final List<String> featureNames;
    @ProtoSerializableField
    private final List<Double> featureScores;
    @ProtoSerializableField
    private final FeatureSetProvenance provenance;
    @ProtoSerializableField(name="ordered")
    private final boolean isOrdered;

    public SelectedFeatureSet(List<String> featureNames, List<Double> featureScores, boolean isOrdered, FeatureSetProvenance provenance) {
        this.featureNames = Collections.unmodifiableList(featureNames);
        this.featureScores = Collections.unmodifiableList(featureScores);
        this.isOrdered = isOrdered;
        this.provenance = provenance;
    }

    public static SelectedFeatureSet deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        SelectedFeatureSetProto proto = (SelectedFeatureSetProto)message.unpack(SelectedFeatureSetProto.class);
        if (proto.getFeatureNamesCount() != proto.getFeatureScoresCount()) {
            throw new IllegalStateException("Invalid protobuf, mismatch between the number of features and the number of scores, found " + proto.getFeatureNamesCount() + " features and " + proto.getFeatureScoresCount() + " scores");
        }
        ObjectProvenance prov = ProvenanceUtil.unmarshalProvenance((List)PROVENANCE_SERIALIZER.deserializeFromProto(proto.getProvenance()));
        if (!(prov instanceof FeatureSetProvenance)) {
            throw new IllegalStateException("Invalid protobuf, provenance was not a FeatureSetProvenance, found " + prov.getClass());
        }
        FeatureSetProvenance fsProv = (FeatureSetProvenance)prov;
        return new SelectedFeatureSet((List<String>)proto.getFeatureNamesList(), proto.getFeatureScoresList(), proto.getOrdered(), fsProv);
    }

    public List<String> featureNames() {
        return this.featureNames;
    }

    public List<Double> featureScores() {
        return this.featureScores;
    }

    public FeatureSetProvenance provenance() {
        return this.provenance;
    }

    public FeatureSetProvenance getProvenance() {
        return this.provenance;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    public FeatureSetProto serialize() {
        return (FeatureSetProto)ProtoUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectedFeatureSet that = (SelectedFeatureSet)o;
        return this.isOrdered == that.isOrdered && this.featureNames.equals(that.featureNames) && this.featureScores.equals(that.featureScores) && this.provenance.equals(that.provenance);
    }

    public int hashCode() {
        return Objects.hash(this.featureNames, this.featureScores, this.provenance, this.isOrdered);
    }

    public String toString() {
        return "SelectedFeatureSet{featureNames=" + this.featureNames + ", featureScores=" + this.featureScores + ", isOrdered=" + this.isOrdered + '}';
    }
}

