/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import com.google.protobuf.Any;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.tribuo.hash.Hasher;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.HasherProto;

@ProtoSerializableClass(version=0)
public final class HashCodeHasher
extends Hasher {
    private static final long serialVersionUID = 2L;
    public static final int CURRENT_VERSION = 0;
    @Config(mandatory=true, redact=true, description="Salt used in the hash.")
    private transient String salt = null;
    private static final HashCodeHasherProvenance provenance = new HashCodeHasherProvenance();

    private HashCodeHasher() {
    }

    public HashCodeHasher(String salt) {
        this.salt = salt;
        this.postConfig();
    }

    public static HashCodeHasher deserializeFromProto(int version, String className, Any message) {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        return new HashCodeHasher();
    }

    @Override
    public HasherProto serialize() {
        return (HasherProto)ProtoUtil.serialize(this);
    }

    @Override
    public String hash(String name) {
        if (this.salt == null) {
            throw new IllegalStateException("Salt not set");
        }
        String salted = this.salt + name;
        return "" + salted.hashCode();
    }

    public void postConfig() throws PropertyException {
        if (this.salt == null) {
            throw new PropertyException("", "salt", "Salt not set in HashCodeHasher.");
        }
        if (!Hasher.validateSalt(this.salt)) {
            throw new PropertyException("", "salt", "Salt does not meet the requirements for a salt.");
        }
    }

    @Override
    public void setSalt(String salt) {
        if (!Hasher.validateSalt(salt)) {
            throw new IllegalArgumentException("Salt: '" + salt + ", does not meet the requirements for a salt.");
        }
        this.salt = salt;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return provenance;
    }

    public String toString() {
        return "HashCodeHasher()";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashCodeHasher that = (HashCodeHasher)o;
        return Objects.equals(this.salt, that.salt);
    }

    public int hashCode() {
        return Objects.hash(this.salt);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.salt = null;
    }

    public static final class HashCodeHasherProvenance
    implements ConfiguredObjectProvenance {
        private static final long serialVersionUID = 1L;

        HashCodeHasherProvenance() {
        }

        public HashCodeHasherProvenance(Map<String, Provenance> map) {
        }

        public Map<String, Provenance> getConfiguredParameters() {
            return Collections.singletonMap("salt", new StringProvenance("salt", ""));
        }

        public String getClassName() {
            return HashCodeHasher.class.getName();
        }

        public String toString() {
            return this.generateString("Hasher");
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object other) {
            return other instanceof HashCodeHasher;
        }
    }
}

