/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.tribuo.hash.Hasher;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.HasherProto;
import org.tribuo.protos.core.MessageDigestHasherProto;

@ProtoSerializableClass(version=0, serializedDataClass=MessageDigestHasherProto.class)
public final class MessageDigestHasher
extends Hasher {
    private static final long serialVersionUID = 3L;
    public static final int CURRENT_VERSION = 0;
    public static final Charset utf8Charset = StandardCharsets.UTF_8;
    static final String HASH_TYPE = "hashType";
    @Config(mandatory=true, description="MessageDigest hashing function.")
    @ProtoSerializableField
    private String hashType;
    private transient ThreadLocal<MessageDigest> md;
    @Config(mandatory=true, description="Salt used in the hash.", redact=true)
    private transient String saltStr = null;
    private transient byte[] salt = null;
    private MessageDigestHasherProvenance provenance;

    private MessageDigestHasher() {
    }

    public MessageDigestHasher(String hashType, String salt) {
        this.hashType = hashType;
        if (!Hasher.validateSalt(salt)) {
            throw new IllegalArgumentException("Salt: '" + salt + ", does not meet the requirements for a salt.");
        }
        this.salt = salt.getBytes(utf8Charset);
        this.md = ThreadLocal.withInitial(MessageDigestHasher.getDigestSupplier(hashType));
        MessageDigest d = this.md.get();
        this.provenance = new MessageDigestHasherProvenance(hashType);
    }

    public static MessageDigestHasher deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        MessageDigestHasher obj = new MessageDigestHasher();
        MessageDigestHasherProto proto = (MessageDigestHasherProto)message.unpack(MessageDigestHasherProto.class);
        obj.hashType = proto.getHashType();
        obj.md = ThreadLocal.withInitial(MessageDigestHasher.getDigestSupplier(obj.hashType));
        MessageDigest d = obj.md.get();
        obj.provenance = new MessageDigestHasherProvenance(obj.hashType);
        return obj;
    }

    public void postConfig() throws PropertyException {
        if (this.saltStr != null) {
            if (!Hasher.validateSalt(this.saltStr)) {
                throw new PropertyException("", "saltStr", "Salt does not meet the requirements for a salt.");
            }
        } else {
            throw new PropertyException("", "saltStr", "Salt not set in MessageDigestHasher.");
        }
        this.salt = this.saltStr.getBytes(utf8Charset);
        this.md = ThreadLocal.withInitial(MessageDigestHasher.getDigestSupplier(this.hashType));
        try {
            MessageDigest messageDigest = this.md.get();
        }
        catch (IllegalArgumentException e) {
            throw new PropertyException("", HASH_TYPE, "Unsupported hashType = " + this.hashType);
        }
        this.provenance = new MessageDigestHasherProvenance(this.hashType);
    }

    @Override
    public String hash(String input) {
        if (this.salt == null) {
            throw new IllegalStateException("Salt not set.");
        }
        MessageDigest localDigest = this.md.get();
        localDigest.reset();
        localDigest.update(this.salt);
        byte[] hash = localDigest.digest(input.getBytes(utf8Charset));
        return Base64.getEncoder().encodeToString(hash);
    }

    @Override
    public HasherProto serialize() {
        return (HasherProto)ProtoUtil.serialize(this);
    }

    @Override
    public void setSalt(String salt) {
        if (!Hasher.validateSalt(salt)) {
            throw new IllegalArgumentException("Salt: '" + salt + "', does not meet the requirements for a salt.");
        }
        this.salt = salt.getBytes(utf8Charset);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.salt = null;
        this.saltStr = null;
        this.md = ThreadLocal.withInitial(MessageDigestHasher.getDigestSupplier(this.hashType));
    }

    public String toString() {
        return "MessageDigestHasher(algorithm=" + this.md.get().getAlgorithm() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDigestHasher that = (MessageDigestHasher)o;
        return Objects.equals(this.hashType, that.hashType) && Arrays.equals(this.salt, that.salt);
    }

    public int hashCode() {
        int result = Objects.hash(this.hashType);
        result = 31 * result + Arrays.hashCode(this.salt);
        return result;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return this.provenance;
    }

    public static Supplier<MessageDigest> getDigestSupplier(String hashType) {
        return () -> {
            try {
                return MessageDigest.getInstance(hashType);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Unsupported hashType = " + hashType, e);
            }
        };
    }

    public static final class MessageDigestHasherProvenance
    implements ConfiguredObjectProvenance {
        private static final long serialVersionUID = 1L;
        private final StringProvenance hashType;

        MessageDigestHasherProvenance(String hashType) {
            this.hashType = new StringProvenance(MessageDigestHasher.HASH_TYPE, hashType);
        }

        public MessageDigestHasherProvenance(Map<String, Provenance> map) {
            this.hashType = (StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)MessageDigestHasher.HASH_TYPE, StringProvenance.class, (String)MessageDigestHasherProvenance.class.getSimpleName());
        }

        public Map<String, Provenance> getConfiguredParameters() {
            HashMap<String, Provenance> map = new HashMap<String, Provenance>();
            map.put("saltStr", (Provenance)new StringProvenance("saltStr", ""));
            map.put(MessageDigestHasher.HASH_TYPE, (Provenance)this.hashType);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MessageDigestHasherProvenance)) {
                return false;
            }
            MessageDigestHasherProvenance pairs = (MessageDigestHasherProvenance)o;
            return this.hashType.equals((Object)pairs.hashType);
        }

        public int hashCode() {
            return Objects.hash(this.hashType);
        }

        public String getClassName() {
            return MessageDigestHasher.class.getName();
        }

        public String toString() {
            return this.generateString("Hasher");
        }
    }
}

