/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.hash.Hasher;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.HasherProto;
import org.tribuo.protos.core.ModHashCodeHasherProto;

@ProtoSerializableClass(version=0, serializedDataClass=ModHashCodeHasherProto.class)
public final class ModHashCodeHasher
extends Hasher {
    private static final long serialVersionUID = 2L;
    public static final int CURRENT_VERSION = 0;
    static final String DIMENSION = "dimension";
    @Config(mandatory=true, redact=true, description="Salt used in the hash.")
    private transient String salt = null;
    @ProtoSerializableField
    @Config(mandatory=true, description="Range of the hashing function.")
    private int dimension = 100;
    private ModHashCodeHasherProvenance provenance;

    private ModHashCodeHasher() {
    }

    public ModHashCodeHasher(String salt) {
        this(100, salt);
    }

    public ModHashCodeHasher(int dimension, String salt) {
        this.dimension = dimension;
        this.salt = salt;
        this.postConfig();
    }

    public static ModHashCodeHasher deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ModHashCodeHasherProto proto = (ModHashCodeHasherProto)message.unpack(ModHashCodeHasherProto.class);
        ModHashCodeHasher obj = new ModHashCodeHasher();
        obj.dimension = proto.getDimension();
        obj.provenance = new ModHashCodeHasherProvenance(obj.dimension);
        return obj;
    }

    @Override
    public HasherProto serialize() {
        return (HasherProto)ProtoUtil.serialize(this);
    }

    public void postConfig() throws PropertyException {
        if (this.salt == null) {
            throw new PropertyException("", "salt", "Salt not set in ModHashCodeHasher.");
        }
        if (!Hasher.validateSalt(this.salt)) {
            throw new PropertyException("", "salt", "Salt does not meet the requirements for a salt.");
        }
        this.provenance = new ModHashCodeHasherProvenance(this.dimension);
    }

    @Override
    public String hash(String name) {
        if (this.salt == null) {
            throw new IllegalStateException("Salt not set");
        }
        String salted = this.salt + name;
        return "" + salted.hashCode() % this.dimension;
    }

    @Override
    public void setSalt(String salt) {
        if (!Hasher.validateSalt(salt)) {
            throw new IllegalArgumentException("Salt: '" + salt + ", does not meet the requirements for a salt.");
        }
        this.salt = salt;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        return "ModHashCodeHasher(dimension=" + this.dimension + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModHashCodeHasher that = (ModHashCodeHasher)o;
        return this.dimension == that.dimension && Objects.equals(this.salt, that.salt);
    }

    public int hashCode() {
        return Objects.hash(this.salt, this.dimension);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.salt = null;
    }

    public static final class ModHashCodeHasherProvenance
    implements ConfiguredObjectProvenance {
        private static final long serialVersionUID = 1L;
        private final IntProvenance dimension;

        ModHashCodeHasherProvenance(int dimension) {
            this.dimension = new IntProvenance(ModHashCodeHasher.DIMENSION, dimension);
        }

        public ModHashCodeHasherProvenance(Map<String, Provenance> map) {
            this.dimension = (IntProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)ModHashCodeHasher.DIMENSION, IntProvenance.class, (String)ModHashCodeHasherProvenance.class.getSimpleName());
        }

        public Map<String, Provenance> getConfiguredParameters() {
            HashMap<String, Provenance> map = new HashMap<String, Provenance>();
            map.put("saltStr", (Provenance)new StringProvenance("saltStr", ""));
            map.put(ModHashCodeHasher.DIMENSION, (Provenance)this.dimension);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModHashCodeHasherProvenance)) {
                return false;
            }
            ModHashCodeHasherProvenance pairs = (ModHashCodeHasherProvenance)o;
            return this.dimension.equals((Object)pairs.dimension);
        }

        public int hashCode() {
            return Objects.hash(this.dimension);
        }

        public String getClassName() {
            return ModHashCodeHasher.class.getName();
        }

        public String toString() {
            return this.generateString("Hasher");
        }
    }
}

