/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.impl;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.util.SortUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.Output;
import org.tribuo.VariableInfo;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.ExampleDataProto;
import org.tribuo.protos.core.ExampleProto;
import org.tribuo.protos.core.OutputProto;
import org.tribuo.transform.Transformer;
import org.tribuo.transform.TransformerMap;
import org.tribuo.util.Merger;

public class ArrayExample<T extends Output<T>>
extends Example<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ArrayExample.class.getName());
    public static final int CURRENT_VERSION = 0;
    public static final int DEFAULT_SIZE = 10;
    protected String[] featureNames;
    protected double[] featureValues;
    protected int size = 0;

    public ArrayExample(T output, float weight, int initialSize) {
        super(output, weight);
        this.featureNames = new String[initialSize];
        this.featureValues = new double[initialSize];
    }

    public ArrayExample(T output, float weight, Map<String, Object> metadata) {
        super(output, weight, metadata);
        this.featureNames = new String[10];
        this.featureValues = new double[10];
    }

    public ArrayExample(T output, float weight) {
        super(output, weight);
        this.featureNames = new String[10];
        this.featureValues = new double[10];
    }

    public ArrayExample(T output, Map<String, Object> metadata) {
        super(output, metadata);
        this.featureNames = new String[10];
        this.featureValues = new double[10];
    }

    public ArrayExample(T output) {
        super(output);
        this.featureNames = new String[10];
        this.featureValues = new double[10];
    }

    public ArrayExample(T output, String[] names, double[] values) {
        super(output);
        if (names.length != values.length) {
            throw new IllegalArgumentException("names.length != values.length, names = " + names.length + ", values = " + values.length);
        }
        this.size = names.length;
        this.featureNames = Arrays.copyOf(names, names.length);
        this.featureValues = Arrays.copyOf(values, values.length);
        this.sort();
    }

    public ArrayExample(T output, List<? extends Feature> features) {
        super(output);
        this.size = features.size();
        this.featureNames = new String[this.size];
        this.featureValues = new double[this.size];
        int i = 0;
        for (Feature feature : features) {
            this.featureNames[i] = feature.getName();
            this.featureValues[i] = feature.getValue();
            ++i;
        }
        this.sort();
    }

    public ArrayExample(Example<T> other) {
        super(other);
        if (other instanceof ArrayExample) {
            ArrayExample otherArr = (ArrayExample)other;
            this.featureNames = Arrays.copyOf(otherArr.featureNames, otherArr.size);
            this.featureValues = Arrays.copyOf(otherArr.featureValues, otherArr.size);
            this.size = otherArr.size;
        } else {
            this.featureNames = new String[other.size()];
            this.featureValues = new double[other.size()];
            for (Feature f : other) {
                this.featureNames[this.size] = f.getName();
                this.featureValues[this.size] = f.getValue();
                ++this.size;
            }
        }
    }

    public <U extends Output<U>> ArrayExample(T output, Example<U> other, float weight) {
        super(output, weight);
        this.featureNames = new String[other.size()];
        this.featureValues = new double[other.size()];
        for (Feature f : other) {
            this.featureNames[this.size] = f.getName();
            this.featureValues[this.size] = f.getValue();
            ++this.size;
        }
    }

    private ArrayExample(T output, float weight, String[] featureNames, double[] featureValues, Map<String, String> metadata) {
        super(output, weight);
        this.featureNames = Arrays.copyOf(featureNames, featureNames.length);
        this.featureValues = Arrays.copyOf(featureValues, featureValues.length);
        this.size = featureNames.length;
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            this.setMetadataValue(e.getKey(), e.getValue());
        }
    }

    public static ArrayExample<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ExampleDataProto proto = (ExampleDataProto)message.unpack(ExampleDataProto.class);
        if (proto.getFeatureNameCount() != proto.getFeatureValueCount()) {
            throw new IllegalStateException("Invalid protobuf, different numbers of feature names and values, found " + proto.getFeatureNameCount() + " names and " + proto.getFeatureValueCount() + " values.");
        }
        Output output = (Output)ProtoUtil.deserialize(proto.getOutput());
        String[] featureNames = new String[proto.getFeatureNameCount()];
        double[] featureValues = new double[proto.getFeatureValueCount()];
        for (int i = 0; i < proto.getFeatureNameCount(); ++i) {
            featureNames[i] = proto.getFeatureName(i);
            featureValues[i] = proto.getFeatureValue(i);
        }
        return new ArrayExample<Output>(output, proto.getWeight(), featureNames, featureValues, proto.getMetadataMap());
    }

    public void add(String name, double value) {
        if (this.size >= this.featureNames.length) {
            this.growArray();
        }
        this.featureNames[this.size] = name;
        this.featureValues[this.size] = value;
        ++this.size;
        this.sort();
    }

    @Override
    public void add(Feature feature) {
        this.add(feature.getName(), feature.getValue());
    }

    @Override
    public void addAll(Collection<? extends Feature> features) {
        if (this.size + features.size() >= this.featureNames.length) {
            this.growArray(this.size + features.size());
        }
        for (Feature feature : features) {
            this.featureNames[this.size] = feature.getName();
            this.featureValues[this.size] = feature.getValue();
            ++this.size;
        }
        this.sort();
    }

    protected void growArray(int minCapacity) {
        int newCapacity = this.newCapacity(minCapacity);
        this.featureNames = Arrays.copyOf(this.featureNames, newCapacity);
        this.featureValues = Arrays.copyOf(this.featureValues, newCapacity);
    }

    protected void growArray() {
        this.growArray(this.size + 1);
    }

    protected int newCapacity(int minCapacity) {
        int oldCapacity = this.featureNames.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity <= 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity;
        }
        return newCapacity;
    }

    @Override
    protected void sort() {
        int[] sortedIndices = SortUtil.argsort((Comparable[])this.featureNames, (int)0, (int)this.size, (boolean)true);
        String[] newNames = Arrays.copyOf(this.featureNames, this.size);
        double[] newValues = Arrays.copyOf(this.featureValues, this.size);
        for (int i = 0; i < sortedIndices.length; ++i) {
            this.featureNames[i] = newNames[sortedIndices[i]];
            this.featureValues[i] = newValues[sortedIndices[i]];
        }
    }

    public double[] copyValues(int newSize) {
        return Arrays.copyOf(this.featureValues, newSize);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void removeFeatures(List<Feature> featureList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (int i = 0; i < this.featureNames.length; ++i) {
            List list = map.computeIfAbsent(this.featureNames[i], k -> new ArrayList());
            list.add(i);
        }
        PriorityQueue removeQueue = new PriorityQueue();
        for (Feature f : featureList) {
            List i = (List)map.get(f.getName());
            if (i == null) continue;
            map.remove(f.getName());
            removeQueue.addAll(i);
        }
        String[] newNames = new String[this.size - removeQueue.size()];
        double[] newValues = new double[this.size - removeQueue.size()];
        int source = 0;
        int dest = 0;
        while (!removeQueue.isEmpty()) {
            int curRemoveIdx = (Integer)removeQueue.poll();
            while (source < curRemoveIdx) {
                newNames[dest] = this.featureNames[source];
                newValues[dest] = this.featureValues[source];
                ++source;
                ++dest;
            }
            ++source;
        }
        while (source < this.size) {
            newNames[dest] = this.featureNames[source];
            newValues[dest] = this.featureValues[source];
            ++source;
            ++dest;
        }
        this.featureNames = newNames;
        this.featureValues = newValues;
        this.size = this.featureNames.length;
    }

    @Override
    public void reduceByName(Merger merger) {
        if (this.size > 0) {
            int[] sortedIndices = SortUtil.argsort((Comparable[])this.featureNames, (int)0, (int)this.size, (boolean)true);
            String[] newNames = new String[this.featureNames.length];
            double[] newValues = new double[this.featureNames.length];
            for (int i = 0; i < sortedIndices.length; ++i) {
                newNames[i] = this.featureNames[sortedIndices[i]];
                newValues[i] = this.featureValues[sortedIndices[i]];
            }
            this.featureNames[0] = newNames[0];
            this.featureValues[0] = newValues[0];
            int dest = 0;
            for (int i = 1; i < this.size; ++i) {
                while (i < this.size && newNames[i].equals(this.featureNames[dest])) {
                    this.featureValues[dest] = merger.merge(this.featureValues[dest], newValues[i]);
                    ++i;
                }
                if (i >= this.size) continue;
                this.featureNames[++dest] = newNames[i];
                this.featureValues[dest] = newValues[i];
            }
            this.size = dest + 1;
        } else {
            logger.finer("Reducing an example with no features.");
        }
    }

    @Override
    public boolean validateExample() {
        if (this.size == 0) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!Double.isNaN(this.featureValues[i])) continue;
            return false;
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(this.featureNames).subList(0, this.size));
        return names.size() == this.size;
    }

    @Override
    public ArrayExample<T> copy() {
        return new ArrayExample<T>(this);
    }

    @Override
    public Feature lookup(String i) {
        int index = Arrays.binarySearch(this.featureNames, 0, this.size, i);
        if (index < 0) {
            return null;
        }
        return new Feature(this.featureNames[index], this.featureValues[index]);
    }

    @Override
    public void set(Feature feature) {
        int index = Arrays.binarySearch(this.featureNames, 0, this.size, feature.getName());
        if (index < 0) {
            throw new IllegalArgumentException("Feature " + feature + " not found in example.");
        }
        this.featureValues[index] = feature.getValue();
    }

    @Override
    public void transform(TransformerMap transformerMap) {
        if (transformerMap.size() < this.size) {
            for (Map.Entry<String, List<Transformer>> e : transformerMap.entrySet()) {
                int index = Arrays.binarySearch(this.featureNames, 0, this.size, e.getKey());
                if (index < 0) continue;
                double value = this.featureValues[index];
                for (Transformer t : e.getValue()) {
                    value = t.transform(value);
                }
                this.featureValues[index] = value;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                List<Transformer> l = transformerMap.get(this.featureNames[i]);
                if (l == null) continue;
                double value = this.featureValues[i];
                for (Transformer t : l) {
                    value = t.transform(value);
                }
                this.featureValues[i] = value;
            }
        }
    }

    @Override
    public boolean isDense(FeatureMap fMap) {
        if (fMap.size() == this.size()) {
            for (String name : this.featureNames) {
                if (fMap.get(name) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void densify(List<String> featureList) {
        int featureListSize = featureList.size();
        ArrayList<String> insertionList = new ArrayList<String>();
        int thisIdx = 0;
        int otherIdx = 0;
        while (thisIdx < this.size && otherIdx < featureListSize) {
            String curName = featureList.get(otherIdx);
            int comp = curName.compareTo(this.featureNames[thisIdx]);
            if (comp < 0) {
                insertionList.add(curName);
                ++otherIdx;
                continue;
            }
            if (comp == 0) {
                ++thisIdx;
                ++otherIdx;
                continue;
            }
            ++thisIdx;
        }
        while (otherIdx < featureListSize) {
            insertionList.add(featureList.get(otherIdx));
            ++otherIdx;
        }
        int capacityCheck = insertionList.size() + this.size;
        if (capacityCheck > this.featureNames.length) {
            this.growArray(capacityCheck);
        }
        Iterator iterator = insertionList.iterator();
        while (iterator.hasNext()) {
            String s;
            this.featureNames[this.size] = s = (String)iterator.next();
            ++this.size;
        }
        this.sort();
    }

    @Override
    public Iterator<Feature> iterator() {
        return new ArrayExampleIterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ArrayExample(numFeatures=");
        builder.append(this.size);
        builder.append(",output=");
        builder.append(this.output);
        builder.append(",weight=");
        builder.append(this.weight);
        if (this.metadata != null) {
            builder.append(",metadata=");
            builder.append(this.metadata.toString());
        }
        builder.append(",features=[");
        for (int i = 0; i < this.size; ++i) {
            builder.append('(').append(this.featureNames[i]).append(", ").append(this.featureValues[i]).append(')');
            if (i == 0) continue;
            builder.append(", ");
        }
        builder.append("])");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayExample)) {
            return false;
        }
        ArrayExample that = (ArrayExample)o;
        if (Objects.equals(this.metadata, that.metadata) && this.output.getClass().equals(that.output.getClass())) {
            boolean outputTest = this.output.fullEquals(that.output);
            if (outputTest && this.size == that.size) {
                for (int i = 0; i < this.size; ++i) {
                    if (!this.featureNames[i].equals(that.featureNames[i])) {
                        return false;
                    }
                    if (this.featureValues[i] == that.featureValues[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + this.output.hashCode();
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.featureNames[i].hashCode();
            result = 31 * result + Double.hashCode(this.featureValues[i]);
        }
        return result;
    }

    @Override
    public void canonicalize(FeatureMap featureMap) {
        for (int i = 0; i < this.featureNames.length; ++i) {
            VariableInfo vi = featureMap.get(this.featureNames[i]);
            if (vi == null) continue;
            this.featureNames[i] = vi.getName();
        }
    }

    @Override
    public ExampleProto serialize() {
        ExampleProto.Builder builder = ExampleProto.newBuilder();
        builder.setClassName(ArrayExample.class.getName());
        builder.setVersion(0);
        ExampleDataProto.Builder exampleBuilder = ExampleDataProto.newBuilder();
        exampleBuilder.setWeight(this.weight);
        exampleBuilder.setOutput((OutputProto)this.output.serialize());
        for (int i = 0; i < this.size; ++i) {
            exampleBuilder.addFeatureName(this.featureNames[i]);
            exampleBuilder.addFeatureValue(this.featureValues[i]);
        }
        if (this.metadata != null) {
            for (Map.Entry e : this.metadata.entrySet()) {
                if (!(e.getValue() instanceof String)) {
                    logger.warning("Serializing non-string metadata for key '" + (String)e.getKey() + "' of type " + e.getValue().getClass());
                }
                exampleBuilder.putMetadata((String)e.getKey(), e.getValue().toString());
            }
        }
        builder.setSerializedData(Any.pack((Message)exampleBuilder.build()));
        return builder.build();
    }

    class ArrayExampleIterator
    implements Iterator<Feature> {
        int pos = 0;

        ArrayExampleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ArrayExample.this.size;
        }

        @Override
        public Feature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator exhausted at position " + this.pos);
            }
            Feature f = new Feature(ArrayExample.this.featureNames[this.pos], ArrayExample.this.featureValues[this.pos]);
            ++this.pos;
            return f;
        }
    }
}

