/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.impl;

import com.oracle.labs.mlrg.olcut.config.protobuf.ProtoProvenanceSerialization;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.RootProvenanceProto;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.tribuo.FeatureMap;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.protos.core.DatasetDataProto;
import org.tribuo.protos.core.FeatureDomainProto;
import org.tribuo.protos.core.OutputDomainProto;
import org.tribuo.protos.core.OutputFactoryProto;
import org.tribuo.provenance.DataProvenance;

public final class DatasetDataCarrier<T extends Output<T>> {
    private static final ProtoProvenanceSerialization PROVENANCE_SERIALIZER = new ProtoProvenanceSerialization(false);
    private final DataProvenance provenance;
    private final FeatureMap featureDomain;
    private final OutputInfo<T> outputDomain;
    private final List<ObjectProvenance> transformProvenances;
    private final OutputFactory<T> outputFactory;
    private final String tribuoVersion;

    public DatasetDataCarrier(DataProvenance provenance, FeatureMap featureDomain, OutputInfo<T> outputDomain, OutputFactory<T> outputFactory, List<ObjectProvenance> transformProvenances, String tribuoVersion) {
        this.provenance = provenance;
        this.featureDomain = featureDomain;
        this.outputDomain = outputDomain;
        this.outputFactory = outputFactory;
        this.transformProvenances = Collections.unmodifiableList(transformProvenances);
        this.tribuoVersion = tribuoVersion;
    }

    public static DatasetDataCarrier<?> deserialize(DatasetDataProto proto) {
        DataProvenance provenance = (DataProvenance)ProvenanceUtil.unmarshalProvenance((List)PROVENANCE_SERIALIZER.deserializeFromProto(proto.getProvenance()));
        FeatureMap featureDomain = FeatureMap.deserialize(proto.getFeatureDomain());
        OutputInfo<?> outputDomain = OutputInfo.deserialize(proto.getOutputDomain());
        OutputFactory<?> outputFactory = OutputFactory.deserialize(proto.getOutputFactory());
        if (outputDomain.getDomain().iterator().next().getClass() != outputFactory.getUnknownOutput().getClass()) {
            throw new IllegalStateException("Invalid protobuf, output domain and output factory use different outputs, output domain " + outputDomain.getClass() + ", output factory " + outputFactory.getClass());
        }
        ArrayList<ObjectProvenance> transformProvenances = new ArrayList<ObjectProvenance>();
        for (RootProvenanceProto p : proto.getTransformProvenanceList()) {
            ObjectProvenance prov = ProvenanceUtil.unmarshalProvenance((List)PROVENANCE_SERIALIZER.deserializeFromProto(p));
            transformProvenances.add(prov);
        }
        String tribuoVersion = proto.getTribuoVersion();
        return new DatasetDataCarrier(provenance, featureDomain, outputDomain, outputFactory, transformProvenances, tribuoVersion);
    }

    public DatasetDataProto serialize() {
        DatasetDataProto.Builder builder = DatasetDataProto.newBuilder();
        builder.setFeatureDomain((FeatureDomainProto)this.featureDomain.serialize());
        builder.setOutputDomain((OutputDomainProto)this.outputDomain.serialize());
        builder.setOutputFactory((OutputFactoryProto)this.outputFactory.serialize());
        builder.setProvenance(PROVENANCE_SERIALIZER.serializeToProto(ProvenanceUtil.marshalProvenance((ObjectProvenance)this.provenance)));
        for (ObjectProvenance o : this.transformProvenances) {
            builder.addTransformProvenance(PROVENANCE_SERIALIZER.serializeToProto(ProvenanceUtil.marshalProvenance((ObjectProvenance)o)));
        }
        builder.setTribuoVersion(this.tribuoVersion);
        return builder.build();
    }

    public DataProvenance provenance() {
        return this.provenance;
    }

    public FeatureMap featureDomain() {
        return this.featureDomain;
    }

    public OutputInfo<T> outputDomain() {
        return this.outputDomain;
    }

    public List<ObjectProvenance> transformProvenances() {
        return this.transformProvenances;
    }

    public OutputFactory<T> outputFactory() {
        return this.outputFactory;
    }

    public String tribuoVersion() {
        return this.tribuoVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetDataCarrier that = (DatasetDataCarrier)o;
        return this.provenance.equals(that.provenance) && this.featureDomain.equals(that.featureDomain) && this.outputDomain.equals(that.outputDomain) && this.transformProvenances.equals(that.transformProvenances) && this.outputFactory.equals(that.outputFactory) && this.tribuoVersion.equals(that.tribuoVersion);
    }

    public int hashCode() {
        return Objects.hash(this.provenance, this.featureDomain, this.outputDomain, this.transformProvenances, this.outputFactory, this.tribuoVersion);
    }

    public String toString() {
        return "DatasetDataCarrier{provenance=" + this.provenance + ", featureDomain=" + this.featureDomain + ", outputDomain=" + this.outputDomain + ", transformProvenances=" + this.transformProvenances + ", outputFactory=" + this.outputFactory + ", tribuoVersion=" + this.tribuoVersion + '}';
    }
}

