/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance;

import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceException;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.BooleanProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.Output;
import org.tribuo.Trainer;
import org.tribuo.provenance.TrainerProvenance;
import org.tribuo.sequence.SequenceTrainer;

public abstract class SkeletalTrainerProvenance
extends SkeletalConfiguredObjectProvenance
implements TrainerProvenance {
    private static final long serialVersionUID = 1L;
    private final IntProvenance invocationCount;
    private final BooleanProvenance isSequence;
    private final StringProvenance version;

    protected <T extends Output<T>> SkeletalTrainerProvenance(Trainer<T> host) {
        super(host, "Trainer");
        this.isSequence = new BooleanProvenance("is-sequence", false);
        this.invocationCount = new IntProvenance("train-invocation-count", host.getInvocationCount());
        this.version = new StringProvenance("tribuo-version", "4.3.1");
    }

    protected <T extends Output<T>> SkeletalTrainerProvenance(SequenceTrainer<T> host) {
        super(host, "SequenceTrainer");
        this.isSequence = new BooleanProvenance("is-sequence", true);
        this.invocationCount = new IntProvenance("train-invocation-count", host.getInvocationCount());
        this.version = new StringProvenance("tribuo-version", "4.3.1");
    }

    protected SkeletalTrainerProvenance(Map<String, Provenance> map) {
        this(SkeletalTrainerProvenance.extractProvenanceInfo(map));
    }

    protected SkeletalTrainerProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
        super(info);
        this.invocationCount = (IntProvenance)SkeletalConfiguredObjectProvenance.checkAndExtractProvenance((SkeletalConfiguredObjectProvenance.ExtractedInfo)info, (String)"train-invocation-count", IntProvenance.class, (String)info.className);
        this.isSequence = (BooleanProvenance)SkeletalConfiguredObjectProvenance.checkAndExtractProvenance((SkeletalConfiguredObjectProvenance.ExtractedInfo)info, (String)"is-sequence", BooleanProvenance.class, (String)info.className);
        this.version = (StringProvenance)SkeletalConfiguredObjectProvenance.checkAndExtractProvenance((SkeletalConfiguredObjectProvenance.ExtractedInfo)info, (String)"tribuo-version", StringProvenance.class, (String)info.className);
    }

    public boolean isSequence() {
        return this.isSequence.getValue();
    }

    public String getTribuoVersion() {
        return this.version.getValue();
    }

    public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
        Map map = super.getInstanceValues();
        map.put("train-invocation-count", this.invocationCount);
        map.put("is-sequence", this.isSequence);
        map.put("tribuo-version", this.version);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkeletalTrainerProvenance)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SkeletalTrainerProvenance pairs = (SkeletalTrainerProvenance)o;
        return this.invocationCount.equals((Object)pairs.invocationCount) && this.isSequence.equals((Object)pairs.isSequence);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.invocationCount, this.isSequence);
    }

    protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
        Provenance tmpProv;
        HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
        HashMap<String, Object> instanceValues = new HashMap<String, Object>();
        if (!configuredParameters.containsKey("class-name")) {
            throw new ProvenanceException("Failed to find class name when constructing SkeletalTrainerProvenance");
        }
        String className = ((Provenance)configuredParameters.remove("class-name")).toString();
        if (!configuredParameters.containsKey("host-short-name")) {
            throw new ProvenanceException("Failed to find host type short name when constructing SkeletalTrainerProvenance");
        }
        String hostTypeStringName = ((Provenance)configuredParameters.remove("host-short-name")).toString();
        if (configuredParameters.containsKey("train-invocation-count")) {
            tmpProv = (Provenance)configuredParameters.remove("train-invocation-count");
            if (!(tmpProv instanceof IntProvenance)) {
                throw new ProvenanceException("train-invocation-count was not of type IntProvenance in class " + className);
            }
        } else {
            throw new ProvenanceException("Failed to find invocation count when constructing SkeletalTrainerProvenance");
        }
        instanceValues.put("train-invocation-count", (IntProvenance)tmpProv);
        if (configuredParameters.containsKey("is-sequence")) {
            tmpProv = (Provenance)configuredParameters.remove("is-sequence");
            if (!(tmpProv instanceof BooleanProvenance)) {
                throw new ProvenanceException("is-sequence was not of type BooleanProvenance in class " + className);
            }
        } else {
            throw new ProvenanceException("Failed to find is-sequence when constructing SkeletalTrainerProvenance");
        }
        instanceValues.put("is-sequence", (BooleanProvenance)tmpProv);
        if (configuredParameters.containsKey("tribuo-version")) {
            tmpProv = (Provenance)configuredParameters.remove("tribuo-version");
            if (!(tmpProv instanceof StringProvenance)) {
                throw new ProvenanceException("tribuo-version was not of type StringProvenance in class " + className);
            }
        } else {
            throw new ProvenanceException("Failed to find Tribuo version when constructing SkeletalTrainerProvenance");
        }
        instanceValues.put("tribuo-version", (StringProvenance)tmpProv);
        return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceValues);
    }
}

