/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.VariableIDInfo;
import org.tribuo.impl.DatasetDataCarrier;
import org.tribuo.protos.core.ImmutableSequenceDatasetProto;
import org.tribuo.protos.core.SequenceDatasetProto;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.sequence.SequenceDataSource;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceExample;
import org.tribuo.sequence.SequenceModel;
import org.tribuo.util.Merger;

public class ImmutableSequenceDataset<T extends Output<T>>
extends SequenceDataset<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    protected ImmutableOutputInfo<T> outputIDInfo;
    protected ImmutableFeatureMap featureIDMap;
    private DatasetProvenance provenance;

    protected ImmutableSequenceDataset(DataProvenance sourceProvenance, OutputFactory<T> outputFactory) {
        super(sourceProvenance, outputFactory);
    }

    public ImmutableSequenceDataset(SequenceDataSource<T> dataSource, SequenceModel<T> model) {
        this(dataSource, (DataProvenance)dataSource.getProvenance(), model.getFeatureIDMap(), model.getOutputIDInfo(), dataSource.getOutputFactory());
    }

    public ImmutableSequenceDataset(SequenceDataSource<T> dataSource, FeatureMap featureIDMap, OutputInfo<T> outputIDInfo) {
        this(dataSource, (DataProvenance)dataSource.getProvenance(), featureIDMap, outputIDInfo, dataSource.getOutputFactory());
    }

    public ImmutableSequenceDataset(Iterable<SequenceExample<T>> dataSource, DataProvenance sourceProvenance, FeatureMap featureIDMap, OutputInfo<T> outputIDInfo, OutputFactory<T> outputFactory) {
        this(dataSource, sourceProvenance, new ImmutableFeatureMap(featureIDMap), outputIDInfo.generateImmutableOutputInfo(), outputFactory);
    }

    public ImmutableSequenceDataset(Iterable<SequenceExample<T>> dataSource, DataProvenance sourceProvenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, OutputFactory<T> outputFactory) {
        super(sourceProvenance, outputFactory);
        this.featureIDMap = featureIDMap;
        this.outputIDInfo = outputIDInfo;
        for (SequenceExample<T> ex : dataSource) {
            this.add(ex);
        }
    }

    protected ImmutableSequenceDataset(DataProvenance sourceProvenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo) {
        super(sourceProvenance, null);
        this.featureIDMap = featureIDMap;
        this.outputIDInfo = outputIDInfo;
    }

    protected ImmutableSequenceDataset(DataProvenance provenance, OutputFactory<T> factory, String tribuoVersion, ImmutableFeatureMap fmap, ImmutableOutputInfo<T> outputInfo, List<SequenceExample<T>> examples) {
        super(provenance, factory, tribuoVersion);
        this.featureIDMap = fmap;
        this.outputIDInfo = outputInfo;
        this.data.addAll(examples);
    }

    public static ImmutableSequenceDataset<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ImmutableSequenceDatasetProto proto = (ImmutableSequenceDatasetProto)message.unpack(ImmutableSequenceDatasetProto.class);
        DatasetDataCarrier<?> carrier = DatasetDataCarrier.deserialize(proto.getMetadata());
        Class<?> outputClass = carrier.outputFactory().getUnknownOutput().getClass();
        FeatureMap fmap = carrier.featureDomain();
        List examples = ImmutableSequenceDataset.deserializeExamples(proto.getExamplesList(), outputClass, fmap);
        if (!(fmap instanceof ImmutableFeatureMap)) {
            throw new IllegalStateException("Invalid protobuf, feature map was not immutable");
        }
        if (!(carrier.outputDomain() instanceof ImmutableOutputInfo)) {
            throw new IllegalStateException("Invalid protobuf, output info was not immutable");
        }
        return new ImmutableSequenceDataset(carrier.provenance(), carrier.outputFactory(), carrier.tribuoVersion(), (ImmutableFeatureMap)fmap, (ImmutableOutputInfo)carrier.outputDomain(), examples);
    }

    protected void add(SequenceExample<T> ex) {
        if (ex.size() > 0) {
            ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
            for (Example<T> e : ex) {
                featuresToRemove.clear();
                for (Feature f : e) {
                    VariableIDInfo info = this.featureIDMap.get(f.getName());
                    if (info != null) continue;
                    featuresToRemove.add(f);
                }
                e.removeFeatures(featuresToRemove);
                if (e.validateExample()) continue;
                throw new IllegalStateException("Duplicate features or invalid features inside the Example, or all features were removed.");
            }
        } else {
            throw new IllegalArgumentException("SequenceExample is empty.");
        }
        this.data.add(ex);
        ex.canonicalise(this.featureIDMap);
    }

    private void unsafeAdd(SequenceExample<T> ex) {
        this.data.add(ex);
    }

    protected void add(SequenceExample<T> ex, Merger merger) {
        if (ex.size() > 0) {
            this.data.add(ex);
            ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
            for (Example<T> e : ex) {
                featuresToRemove.clear();
                for (Feature f : e) {
                    VariableIDInfo info = this.featureIDMap.get(f.getName());
                    if (info != null) continue;
                    featuresToRemove.add(f);
                }
                e.removeFeatures(featuresToRemove);
                e.reduceByName(merger);
                if (e.validateExample()) continue;
                throw new IllegalStateException("Duplicate features or invalid features inside the Example, or all features were removed.");
            }
        } else {
            throw new IllegalArgumentException("SequenceExample is empty.");
        }
    }

    @Override
    public Set<T> getOutputs() {
        return this.outputIDInfo.getDomain();
    }

    @Override
    public ImmutableFeatureMap getFeatureIDMap() {
        return this.featureIDMap;
    }

    @Override
    public ImmutableFeatureMap getFeatureMap() {
        return this.featureIDMap;
    }

    @Override
    public ImmutableOutputInfo<T> getOutputIDInfo() {
        return this.outputIDInfo;
    }

    @Override
    public ImmutableOutputInfo<T> getOutputInfo() {
        return this.outputIDInfo;
    }

    @Override
    public String toString() {
        return "ImmutableSequenceDataset(source=" + this.sourceProvenance.toString() + ")";
    }

    @Override
    public SequenceDatasetProto serialize() {
        ImmutableSequenceDatasetProto.Builder datasetBuilder = ImmutableSequenceDatasetProto.newBuilder();
        datasetBuilder.setMetadata(this.createDataCarrier(this.featureIDMap, this.outputIDInfo).serialize());
        for (SequenceExample e : this.data) {
            datasetBuilder.addExamples(e.serialize());
        }
        SequenceDatasetProto.Builder builder = SequenceDatasetProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(ImmutableSequenceDataset.class.getName());
        builder.setSerializedData(Any.pack((Message)datasetBuilder.build()));
        return builder.build();
    }

    public synchronized DatasetProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = this.cacheProvenance();
        }
        return this.provenance;
    }

    private DatasetProvenance cacheProvenance() {
        return new DatasetProvenance(this.sourceProvenance, (ListProvenance<ObjectProvenance>)new ListProvenance(), this);
    }

    public static <T extends Output<T>> ImmutableSequenceDataset<T> copyDataset(SequenceDataset<T> dataset) {
        ArrayList<SequenceExample<T>> newData = new ArrayList<SequenceExample<T>>();
        for (SequenceExample<T> e : dataset) {
            newData.add(e.copy());
        }
        return new ImmutableSequenceDataset<T>(newData, dataset.getSourceProvenance(), (FeatureMap)dataset.getFeatureIDMap(), dataset.getOutputInfo(), dataset.getOutputFactory());
    }

    public static <T extends Output<T>> ImmutableSequenceDataset<T> copyDataset(SequenceDataset<T> dataset, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo) {
        ArrayList<SequenceExample<T>> newData = new ArrayList<SequenceExample<T>>();
        for (SequenceExample<T> e : dataset) {
            newData.add(e.copy());
        }
        return new ImmutableSequenceDataset<T>(newData, dataset.getSourceProvenance(), featureIDMap, outputIDInfo, dataset.getOutputFactory());
    }

    public static <T extends Output<T>> ImmutableSequenceDataset<T> copyDataset(SequenceDataset<T> dataset, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, Merger merger) {
        ImmutableSequenceDataset<T> copy = new ImmutableSequenceDataset<T>((DataProvenance)dataset.getProvenance(), featureIDMap, outputIDInfo);
        for (SequenceExample<T> e : dataset) {
            copy.add(e.copy(), merger);
        }
        return copy;
    }

    static <T extends Output<T>> ImmutableSequenceDataset<T> changeFeatureMap(SequenceDataset<T> dataset, ImmutableFeatureMap featureIDMap) {
        ImmutableSequenceDataset<T> copy = new ImmutableSequenceDataset<T>((DataProvenance)dataset.getProvenance(), featureIDMap, dataset.getOutputIDInfo());
        for (SequenceExample<T> e : dataset) {
            super.unsafeAdd(e);
        }
        return copy;
    }
}

