/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableFeatureMap;
import org.tribuo.MutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.impl.DatasetDataCarrier;
import org.tribuo.protos.core.MutableSequenceDatasetProto;
import org.tribuo.protos.core.SequenceDatasetProto;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.sequence.ImmutableSequenceDataset;
import org.tribuo.sequence.SequenceDataSource;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceExample;

public class MutableSequenceDataset<T extends Output<T>>
extends SequenceDataset<T> {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    protected final MutableOutputInfo<T> outputInfo;
    protected final MutableFeatureMap featureMap;
    protected boolean dense = true;

    public MutableSequenceDataset(DataProvenance sourceProvenance, OutputFactory<T> outputFactory) {
        super(sourceProvenance, outputFactory);
        this.featureMap = new MutableFeatureMap();
        this.outputInfo = outputFactory.generateInfo();
    }

    public MutableSequenceDataset(Iterable<SequenceExample<T>> dataSource, DataProvenance sourceProvenance, OutputFactory<T> outputFactory) {
        super(sourceProvenance, outputFactory);
        this.featureMap = new MutableFeatureMap();
        this.outputInfo = outputFactory.generateInfo();
        for (SequenceExample<T> ex : dataSource) {
            this.add(ex);
        }
    }

    public MutableSequenceDataset(SequenceDataSource<T> dataSource) {
        this(dataSource, (DataProvenance)dataSource.getProvenance(), dataSource.getOutputFactory());
    }

    public MutableSequenceDataset(ImmutableSequenceDataset<T> dataset) {
        super(dataset.getProvenance(), dataset.getOutputFactory());
        this.featureMap = new MutableFeatureMap();
        this.outputInfo = dataset.getOutputInfo().generateMutableOutputInfo();
        for (SequenceExample ex : dataset) {
            this.add(new SequenceExample(ex));
        }
    }

    private MutableSequenceDataset(DataProvenance provenance, OutputFactory<T> factory, String tribuoVersion, MutableFeatureMap fmap, MutableOutputInfo<T> outputInfo, List<SequenceExample<T>> examples, boolean dense) {
        super(provenance, factory, tribuoVersion);
        this.featureMap = fmap;
        this.outputInfo = outputInfo;
        this.data.addAll(examples);
        this.dense = dense;
    }

    public static MutableSequenceDataset<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        MutableSequenceDatasetProto proto = (MutableSequenceDatasetProto)message.unpack(MutableSequenceDatasetProto.class);
        DatasetDataCarrier<?> carrier = DatasetDataCarrier.deserialize(proto.getMetadata());
        Class<?> outputClass = carrier.outputFactory().getUnknownOutput().getClass();
        FeatureMap fmap = carrier.featureDomain();
        List examples = MutableSequenceDataset.deserializeExamples(proto.getExamplesList(), outputClass, fmap);
        if (!(fmap instanceof MutableFeatureMap)) {
            throw new IllegalStateException("Invalid protobuf, feature map was not mutable");
        }
        if (!(carrier.outputDomain() instanceof MutableOutputInfo)) {
            throw new IllegalStateException("Invalid protobuf, output info was not mutable");
        }
        return new MutableSequenceDataset(carrier.provenance(), carrier.outputFactory(), carrier.tribuoVersion(), (MutableFeatureMap)fmap, (MutableOutputInfo)carrier.outputDomain(), examples, proto.getDense());
    }

    public void clear() {
        this.outputInfo.clear();
        this.featureMap.clear();
        this.data.clear();
        this.dense = true;
    }

    public void add(SequenceExample<T> ex) {
        if (!ex.validateExample()) {
            throw new IllegalArgumentException("SequenceExample had duplicate features, no features or no Examples.");
        }
        this.data.add(ex);
        int oldNumFeatures = this.featureMap.size();
        boolean exampleIsDense = true;
        for (Example<T> e : ex) {
            this.outputInfo.observe(e.getOutput());
            for (Feature f : e) {
                this.featureMap.add(f.getName(), f.getValue());
            }
            if (e.size() == this.featureMap.size()) continue;
            exampleIsDense = false;
        }
        ex.canonicalise(this.featureMap);
        if (oldNumFeatures != 0 && oldNumFeatures < this.featureMap.size() || !exampleIsDense) {
            this.dense = false;
        }
    }

    public void addAll(Collection<SequenceExample<T>> collection) {
        for (SequenceExample<T> e : collection) {
            this.add(e);
        }
    }

    @Override
    public Set<T> getOutputs() {
        return this.outputInfo.getDomain();
    }

    @Override
    public ImmutableFeatureMap getFeatureIDMap() {
        return new ImmutableFeatureMap(this.featureMap);
    }

    @Override
    public MutableFeatureMap getFeatureMap() {
        return this.featureMap;
    }

    @Override
    public ImmutableOutputInfo<T> getOutputIDInfo() {
        return this.outputInfo.generateImmutableOutputInfo();
    }

    @Override
    public OutputInfo<T> getOutputInfo() {
        return this.outputInfo;
    }

    public boolean isDense() {
        return this.dense;
    }

    public void densify() {
        for (SequenceExample example : this.data) {
            example.densify(this.featureMap);
        }
        this.dense = true;
    }

    @Override
    public String toString() {
        return "MutableSequenceDataset(source=" + this.sourceProvenance.toString() + ")";
    }

    public DatasetProvenance getProvenance() {
        return new DatasetProvenance(this.sourceProvenance, (ListProvenance<ObjectProvenance>)new ListProvenance(), this);
    }

    @Override
    public SequenceDatasetProto serialize() {
        MutableSequenceDatasetProto.Builder datasetBuilder = MutableSequenceDatasetProto.newBuilder();
        datasetBuilder.setDense(this.dense);
        datasetBuilder.setMetadata(this.createDataCarrier(this.featureMap, this.outputInfo).serialize());
        for (SequenceExample e : this.data) {
            datasetBuilder.addExamples(e.serialize());
        }
        SequenceDatasetProto.Builder builder = SequenceDatasetProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(MutableSequenceDataset.class.getName());
        builder.setSerializedData(Any.pack((Message)datasetBuilder.build()));
        return builder.build();
    }
}

