/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Excuse;
import org.tribuo.Model;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.transform.TransformerMap;

public class TransformedModel<T extends Output<T>>
extends Model<T> {
    private static final long serialVersionUID = 1L;
    private final Model<T> innerModel;
    private final TransformerMap transformerMap;
    private final boolean densify;
    private ArrayList<String> featureNames;

    TransformedModel(ModelProvenance modelProvenance, Model<T> innerModel, TransformerMap transformerMap, boolean densify) {
        super(innerModel.getName(), modelProvenance, innerModel.getFeatureIDMap(), innerModel.getOutputIDInfo(), innerModel.generatesProbabilities());
        this.innerModel = innerModel;
        this.transformerMap = transformerMap;
        this.densify = densify;
        this.featureNames = new ArrayList<String>(this.featureIDMap.keySet());
        Collections.sort(this.featureNames);
    }

    public TransformerMap getTransformerMap() {
        return this.transformerMap;
    }

    public Model<T> getInnerModel() {
        return this.innerModel;
    }

    public boolean getDensify() {
        return this.densify;
    }

    @Override
    public Prediction<T> predict(Example<T> example) {
        Example<T> transformedExample = this.densify ? this.transformerMap.transformExample(example, this.featureNames) : this.transformerMap.transformExample(example);
        return this.innerModel.predict(transformedExample);
    }

    @Override
    public List<Prediction<T>> predict(Dataset<T> examples) {
        MutableDataset<T> transformedDataset = this.transformerMap.transformDataset(examples, this.densify);
        ArrayList<Prediction<T>> predictions = new ArrayList<Prediction<T>>();
        for (Example example : transformedDataset) {
            predictions.add(this.innerModel.predict(example));
        }
        return predictions;
    }

    @Override
    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        return this.innerModel.getTopFeatures(n);
    }

    @Override
    public Optional<Excuse<T>> getExcuse(Example<T> example) {
        Example<T> transformedExample = this.transformerMap.transformExample(example);
        return this.innerModel.getExcuse(transformedExample);
    }

    @Override
    protected TransformedModel<T> copy(String name, ModelProvenance newProvenance) {
        return new TransformedModel<T>(newProvenance, this.innerModel, this.transformerMap, this.densify);
    }
}

