/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform.transformations;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DoubleProvenance;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.LinearScalingTransformerProto;
import org.tribuo.protos.core.TransformerProto;
import org.tribuo.transform.TransformStatistics;
import org.tribuo.transform.Transformation;
import org.tribuo.transform.TransformationProvenance;
import org.tribuo.transform.Transformer;

public final class LinearScalingTransformation
implements Transformation {
    private static final String TARGET_MIN = "targetMin";
    private static final String TARGET_MAX = "targetMax";
    @Config(mandatory=true, description="Minimum value after transformation.")
    private double targetMin = 0.0;
    @Config(mandatory=true, description="Maximum value after transformation.")
    private double targetMax = 1.0;
    private TransformationProvenance provenance;

    public LinearScalingTransformation() {
    }

    public LinearScalingTransformation(double targetMin, double targetMax) {
        this.targetMin = targetMin;
        this.targetMax = targetMax;
        this.postConfig();
    }

    public void postConfig() {
        if (this.targetMax < this.targetMin) {
            throw new IllegalArgumentException("Range must be positive, min = " + this.targetMin + ", max = " + this.targetMax);
        }
    }

    @Override
    public TransformStatistics createStats() {
        return new LinearScalingStatistics(this.targetMin, this.targetMax);
    }

    public synchronized TransformationProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = new LinearScalingTransformationProvenance(this);
        }
        return this.provenance;
    }

    public String toString() {
        return "LinearScalingTransformation(targetMin=" + this.targetMin + ",targetMax=" + this.targetMax + ")";
    }

    private static class LinearScalingStatistics
    implements TransformStatistics {
        private final double targetMin;
        private final double targetMax;
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;

        public LinearScalingStatistics(double targetMin, double targetMax) {
            this.targetMin = targetMin;
            this.targetMax = targetMax;
        }

        @Override
        public void observeValue(double value) {
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
        }

        @Override
        @Deprecated
        public void observeSparse() {
            this.observeValue(0.0);
        }

        @Override
        public void observeSparse(int count) {
            this.observeValue(0.0);
        }

        @Override
        public Transformer generateTransformer() {
            return new LinearScalingTransformer(this.min, this.max, this.targetMin, this.targetMax);
        }

        public String toString() {
            return "LinearScalingStatistics(min=" + this.min + ",max=" + this.max + ",targetMin=" + this.targetMin + ",targetMax=" + this.targetMax + ")";
        }
    }

    public static final class LinearScalingTransformationProvenance
    implements TransformationProvenance {
        private static final long serialVersionUID = 1L;
        private final DoubleProvenance targetMin;
        private final DoubleProvenance targetMax;

        LinearScalingTransformationProvenance(LinearScalingTransformation host) {
            this.targetMin = new DoubleProvenance(LinearScalingTransformation.TARGET_MIN, host.targetMin);
            this.targetMax = new DoubleProvenance(LinearScalingTransformation.TARGET_MAX, host.targetMax);
        }

        public LinearScalingTransformationProvenance(Map<String, Provenance> map) {
            this.targetMin = (DoubleProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)LinearScalingTransformation.TARGET_MIN, DoubleProvenance.class, (String)LinearScalingTransformationProvenance.class.getSimpleName());
            this.targetMax = (DoubleProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)LinearScalingTransformation.TARGET_MAX, DoubleProvenance.class, (String)LinearScalingTransformationProvenance.class.getSimpleName());
        }

        public String getClassName() {
            return LinearScalingTransformation.class.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinearScalingTransformationProvenance)) {
                return false;
            }
            LinearScalingTransformationProvenance pairs = (LinearScalingTransformationProvenance)o;
            return this.targetMin.equals((Object)pairs.targetMin) && this.targetMax.equals((Object)pairs.targetMax);
        }

        public int hashCode() {
            return Objects.hash(this.targetMin, this.targetMax);
        }

        public Map<String, Provenance> getConfiguredParameters() {
            HashMap<String, DoubleProvenance> map = new HashMap<String, DoubleProvenance>();
            map.put(LinearScalingTransformation.TARGET_MIN, this.targetMin);
            map.put(LinearScalingTransformation.TARGET_MAX, this.targetMax);
            return Collections.unmodifiableMap(map);
        }
    }

    @ProtoSerializableClass(version=0, serializedDataClass=LinearScalingTransformerProto.class)
    static final class LinearScalingTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;
        public static final int CURRENT_VERSION = 0;
        @ProtoSerializableField
        private final double observedMin;
        @ProtoSerializableField
        private final double observedMax;
        @ProtoSerializableField
        private final double targetMin;
        @ProtoSerializableField
        private final double targetMax;
        private final double scalingFactor;
        private final boolean constant;

        LinearScalingTransformer(double observedMin, double observedMax, double targetMin, double targetMax) {
            if (observedMin > observedMax || targetMin > targetMax) {
                throw new IllegalArgumentException("observedMin and targetMin must be less than observedMax and targetMax respectively");
            }
            this.observedMin = observedMin;
            this.observedMax = observedMax;
            this.targetMin = targetMin;
            this.targetMax = targetMax;
            double observedRange = observedMax - observedMin;
            this.constant = observedRange == 0.0;
            double targetRange = targetMax - targetMin;
            this.scalingFactor = targetRange / observedRange;
        }

        static LinearScalingTransformer deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
            LinearScalingTransformerProto proto = (LinearScalingTransformerProto)message.unpack(LinearScalingTransformerProto.class);
            if (version == 0) {
                return new LinearScalingTransformer(proto.getObservedMin(), proto.getObservedMax(), proto.getTargetMin(), proto.getTargetMax());
            }
            throw new IllegalArgumentException("Unknown version " + version + " expected {0}");
        }

        @Override
        public double transform(double input) {
            if (this.constant) {
                return (this.targetMax - this.targetMin) / 2.0;
            }
            if (input < this.observedMin) {
                return this.targetMin;
            }
            if (input > this.observedMax) {
                return this.targetMax;
            }
            return (input - this.observedMin) * this.scalingFactor + this.targetMin;
        }

        @Override
        public TransformerProto serialize() {
            return (TransformerProto)ProtoUtil.serialize(this);
        }

        public String toString() {
            return "LinearScalingTransformer(observedMin=" + this.observedMin + ",observedMax=" + this.observedMax + ",targetMin=" + this.targetMin + ",targetMax=" + this.targetMax + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinearScalingTransformer that = (LinearScalingTransformer)o;
            return Double.compare(that.observedMin, this.observedMin) == 0 && Double.compare(that.observedMax, this.observedMax) == 0 && Double.compare(that.targetMin, this.targetMin) == 0 && Double.compare(that.targetMax, this.targetMax) == 0 && Double.compare(that.scalingFactor, this.scalingFactor) == 0 && this.constant == that.constant;
        }

        public int hashCode() {
            return Objects.hash(this.observedMin, this.observedMax, this.targetMin, this.targetMax, this.scalingFactor, this.constant);
        }
    }
}

