/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform.transformations;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DoubleProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.EnumProvenance;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.SimpleTransformProto;
import org.tribuo.protos.core.TransformerProto;
import org.tribuo.transform.TransformStatistics;
import org.tribuo.transform.Transformation;
import org.tribuo.transform.TransformationProvenance;
import org.tribuo.transform.Transformer;

@ProtoSerializableClass(version=0, serializedDataClass=SimpleTransformProto.class)
public final class SimpleTransform
implements Transformer,
Transformation,
TransformStatistics {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    private static final String OP = "op";
    private static final String OPERAND = "operand";
    private static final String SECOND_OPERAND = "secondOperand";
    public static final double EPSILON = 1.0E-12;
    @ProtoSerializableField
    @Config(mandatory=true, description="Type of the simple transformation.")
    private Operation op;
    @ProtoSerializableField(name="firstOperand")
    @Config(description="Operand (if required).")
    private double operand = Double.NaN;
    @ProtoSerializableField
    @Config(description="Second operand (if required).")
    private double secondOperand = Double.NaN;
    private SerializableDoubleUnaryOperator operation;
    private transient TransformationProvenance provenance;

    private SimpleTransform() {
    }

    SimpleTransform(Operation op, double operand, double secondOperand) {
        this.op = op;
        this.operand = operand;
        this.secondOperand = secondOperand;
        this.postConfig();
    }

    private SimpleTransform(Operation op, double operand) {
        this.op = op;
        this.operand = operand;
        this.postConfig();
    }

    private SimpleTransform(Operation op) {
        this.op = op;
        this.postConfig();
    }

    public void postConfig() {
        switch (this.op) {
            case exp: {
                this.operation = Math::exp;
                break;
            }
            case log: {
                this.operation = Math::log;
                break;
            }
            case add: {
                if (Double.isNaN(this.operand)) {
                    throw new IllegalArgumentException("operand must not be NaN");
                }
                this.operation = input -> input + this.operand;
                break;
            }
            case sub: {
                if (Double.isNaN(this.operand)) {
                    throw new IllegalArgumentException("operand must not be NaN");
                }
                this.operation = input -> input - this.operand;
                break;
            }
            case mul: {
                if (Double.isNaN(this.operand)) {
                    throw new IllegalArgumentException("operand must not be NaN");
                }
                this.operation = input -> input * this.operand;
                break;
            }
            case div: {
                if (Double.isNaN(this.operand)) {
                    throw new IllegalArgumentException("operand must not be NaN");
                }
                this.operation = input -> input / this.operand;
                break;
            }
            case binarise: {
                this.operation = input -> input < 1.0E-12 ? 0.0 : 1.0;
                break;
            }
            case threshold: {
                if (this.operand > this.secondOperand) {
                    throw new IllegalArgumentException("Min must be greater than max, min = " + this.operand + ", max = " + this.secondOperand);
                }
                if (Double.isNaN(this.operand) || Double.isNaN(this.secondOperand)) {
                    throw new IllegalArgumentException("min and/or max must not be NaN");
                }
                this.operation = input -> {
                    if (input < this.operand) {
                        return this.operand;
                    }
                    if (input > this.secondOperand) {
                        return this.secondOperand;
                    }
                    return input;
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + (Object)((Object)this.op) + " is unknown");
            }
        }
    }

    static SimpleTransform deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        SimpleTransformProto proto = (SimpleTransformProto)message.unpack(SimpleTransformProto.class);
        if (version == 0) {
            return new SimpleTransform(Operation.valueOf(proto.getOp()), proto.getFirstOperand(), proto.getSecondOperand());
        }
        throw new IllegalArgumentException("Unknown version " + version + " expected {0}");
    }

    public TransformationProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = new SimpleTransformProvenance(this);
        }
        return this.provenance;
    }

    @Override
    public TransformerProto serialize() {
        return (TransformerProto)ProtoUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTransform that = (SimpleTransform)o;
        return Double.compare(that.operand, this.operand) == 0 && Double.compare(that.secondOperand, this.secondOperand) == 0 && this.op == that.op;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.op, this.operand, this.secondOperand});
    }

    @Override
    public void observeValue(double value) {
    }

    @Override
    @Deprecated
    public void observeSparse() {
    }

    @Override
    public void observeSparse(int count) {
    }

    @Override
    public Transformer generateTransformer() {
        return this;
    }

    @Override
    public TransformStatistics createStats() {
        return this;
    }

    @Override
    public double transform(double input) {
        return this.operation.applyAsDouble(input);
    }

    public String toString() {
        switch (this.op) {
            case exp: {
                return "exp()";
            }
            case log: {
                return "log()";
            }
            case add: {
                return "add(" + this.operand + ")";
            }
            case sub: {
                return "sub(" + this.operand + ")";
            }
            case mul: {
                return "mul(" + this.operand + ")";
            }
            case div: {
                return "div(" + this.operand + ")";
            }
            case binarise: {
                return "binarise()";
            }
            case threshold: {
                return "threshold(min=" + this.operand + ",max=" + this.secondOperand + ")";
            }
        }
        return this.op.toString();
    }

    public static SimpleTransform exp() {
        return new SimpleTransform(Operation.exp);
    }

    public static SimpleTransform log() {
        return new SimpleTransform(Operation.log);
    }

    public static SimpleTransform add(double operand) {
        return new SimpleTransform(Operation.add, operand);
    }

    public static SimpleTransform sub(double operand) {
        return new SimpleTransform(Operation.sub, operand);
    }

    public static SimpleTransform mul(double operand) {
        return new SimpleTransform(Operation.mul, operand);
    }

    public static SimpleTransform div(double operand) {
        return new SimpleTransform(Operation.div, operand);
    }

    public static SimpleTransform binarise() {
        return new SimpleTransform(Operation.binarise);
    }

    public static SimpleTransform threshold(double min, double max) {
        return new SimpleTransform(Operation.threshold, min, max);
    }

    public static enum Operation {
        exp,
        log,
        add,
        sub,
        mul,
        div,
        binarise,
        threshold;

    }

    static interface SerializableDoubleUnaryOperator
    extends DoubleUnaryOperator,
    Serializable {
    }

    public static final class SimpleTransformProvenance
    implements TransformationProvenance {
        private static final long serialVersionUID = 1L;
        private final EnumProvenance<Operation> op;
        private final DoubleProvenance operand;
        private final DoubleProvenance secondOperand;

        SimpleTransformProvenance(SimpleTransform host) {
            this.op = new EnumProvenance(SimpleTransform.OP, (Enum)host.op);
            this.operand = new DoubleProvenance(SimpleTransform.OPERAND, host.operand);
            this.secondOperand = new DoubleProvenance(SimpleTransform.SECOND_OPERAND, host.secondOperand);
        }

        public SimpleTransformProvenance(Map<String, Provenance> map) {
            this.op = (EnumProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)SimpleTransform.OP, EnumProvenance.class, (String)SimpleTransformProvenance.class.getSimpleName());
            this.operand = (DoubleProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)SimpleTransform.OPERAND, DoubleProvenance.class, (String)SimpleTransformProvenance.class.getSimpleName());
            this.secondOperand = (DoubleProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)SimpleTransform.SECOND_OPERAND, DoubleProvenance.class, (String)SimpleTransformProvenance.class.getSimpleName());
        }

        public String getClassName() {
            return SimpleTransform.class.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleTransformProvenance)) {
                return false;
            }
            SimpleTransformProvenance pairs = (SimpleTransformProvenance)o;
            return this.op.equals(pairs.op) && this.operand.equals((Object)pairs.operand) && this.secondOperand.equals((Object)pairs.secondOperand);
        }

        public int hashCode() {
            return Objects.hash(this.op, this.operand, this.secondOperand);
        }

        public Map<String, Provenance> getConfiguredParameters() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(SimpleTransform.OP, this.op);
            map.put(SimpleTransform.OPERAND, this.operand);
            map.put(SimpleTransform.SECOND_OPERAND, this.secondOperand);
            return Collections.unmodifiableMap(map);
        }
    }
}

