/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.ssl;

import io.skylite.common.ssl.KeyStoreUtil;
import io.skylite.common.ssl.SslConfigException;
import io.skylite.common.ssl.SslTrustConfig;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.net.ssl.X509ExtendedTrustManager;

final class StoreTrustConfig
implements SslTrustConfig {
    private final Path path;
    private final char[] password;
    private final String type;
    private final String algorithm;

    StoreTrustConfig(Path path, char[] password, String type, String algorithm) {
        this.path = path;
        this.type = type;
        this.algorithm = algorithm;
        this.password = password;
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return Collections.singleton(this.path);
    }

    @Override
    public X509ExtendedTrustManager createTrustManager() {
        try {
            KeyStore store = KeyStoreUtil.readKeyStore(this.path, this.type, this.password);
            this.checkTrustStore(store);
            return KeyStoreUtil.createTrustManager(store, this.algorithm);
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("cannot create trust manager for path=[" + String.valueOf(this.path == null ? null : this.path.toAbsolutePath()) + "] type=[" + this.type + "] password=[" + (this.password.length == 0 ? "<empty>" : "<non-empty>") + "]", e);
        }
    }

    private void checkTrustStore(KeyStore store) throws GeneralSecurityException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!store.isCertificateEntry(alias)) continue;
            return;
        }
        Object message = this.path != null ? "the truststore [" + String.valueOf(this.path) + "] does not contain any trusted certificate entries" : "the configured PKCS#11 token does not contain any trusted certificate entries";
        throw new SslConfigException((String)message);
    }
}

