/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo;

import io.lucenia.geo.mapper.PointFieldMapper;
import io.lucenia.geo.mapper.ShapeFieldMapper;
import io.lucenia.geo.processor.CircleProcessor;
import io.lucenia.geo.processor.EllipseProcessor;
import io.lucenia.geo.processor.reprojection.ReprojectionIngestProcessor;
import io.lucenia.geo.processor.reprojection.ReprojectionSearchRequestProcessor;
import io.lucenia.geo.processor.reprojection.ReprojectionSearchResponseProcessor;
import io.lucenia.geo.search.aggregations.bucket.composite.GeoTileGridValuesSourceBuilder;
import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoHashGrid;
import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoHashGridAggregationBuilder;
import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoTileGrid;
import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import io.lucenia.geo.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import io.lucenia.geo.search.aggregations.metrics.InternalGeoBounds;
import io.lucenia.geo.search.query.ShapeQueryBuilder;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.SearchPlugin;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.plugins.IngestPlugin;
import io.skylite.core.plugins.MapperPlugin;
import io.skylite.core.plugins.SearchPipelinePlugin;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.index.mapper.GeoShapeFieldMapper;

public class GeoModulePlugin
extends Plugin
implements MapperPlugin,
SearchPlugin,
SearchPipelinePlugin,
IngestPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        return Map.of("geo_shape", GeoShapeFieldMapper.PARSER, "shape", ShapeFieldMapper.PARSER, "point", PointFieldMapper.PARSER);
    }

    public Map<String, AbstractProcessor.Factory<?>> getProcessors(IngestProcessor.Parameters parameters) {
        return Map.of("circle", new CircleProcessor.Factory(), "ellipse", new EllipseProcessor.Factory(), ReprojectionIngestProcessor.TYPE.getPreferredName(), new ReprojectionIngestProcessor.Factory());
    }

    public Map getRequestProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of(ReprojectionSearchRequestProcessor.TYPE.getPreferredName(), new ReprojectionSearchRequestProcessor.Factory());
    }

    public Map getResponseProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of(ReprojectionSearchResponseProcessor.TYPE.getPreferredName(), new ReprojectionSearchResponseProcessor.Factory());
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("shape", ShapeQueryBuilder::new, ShapeQueryBuilder::fromXContent));
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        SearchPlugin.AggregationSpec geoBounds = new SearchPlugin.AggregationSpec("geo_bounds", GeoBoundsAggregationBuilder::new, GeoBoundsAggregationBuilder.PARSER).addResultReader(InternalGeoBounds::new).setAggregatorRegistrar(GeoBoundsAggregationBuilder::registerAggregators);
        SearchPlugin.AggregationSpec geoHashGrid = new SearchPlugin.AggregationSpec("geohash_grid", GeoHashGridAggregationBuilder::new, GeoHashGridAggregationBuilder.PARSER).addResultReader(GeoHashGrid::new).setAggregatorRegistrar(GeoHashGridAggregationBuilder::registerAggregators);
        SearchPlugin.AggregationSpec geoTileGrid = new SearchPlugin.AggregationSpec("geotile_grid", GeoTileGridAggregationBuilder::new, GeoTileGridAggregationBuilder.PARSER).addResultReader(GeoTileGrid::new).setAggregatorRegistrar(GeoTileGridAggregationBuilder::registerAggregators);
        return List.of(geoBounds, geoHashGrid, geoTileGrid);
    }

    public List<SearchPlugin.CompositeAggregationSpec> getCompositeAggregations() {
        return Collections.singletonList(new SearchPlugin.CompositeAggregationSpec(GeoTileGridValuesSourceBuilder::register, GeoTileGridValuesSourceBuilder.class, GeoTileGridValuesSourceBuilder.COMPOSITE_AGGREGATION_SERIALISATION_BYTE_CODE, GeoTileGridValuesSourceBuilder::new, GeoTileGridValuesSourceBuilder::parse, "geotile_grid"));
    }
}

