/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.mapper;

import io.lucenia.geo.search.query.ShapeQueryPointProcessor;
import io.skylite.common.Explicit;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Point;
import io.skylite.core.geo.CartesianPoint;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.opensearch.index.mapper.ShapeQueryable;

public class PointFieldMapper
extends AbstractPointGeometryFieldMapper<ParsedCartesianPoint> {
    public static final String CONTENT_TYPE = "point";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())));
    private final Builder builder;

    private static Builder builder(FieldMapper in) {
        return ((PointFieldMapper)in).builder;
    }

    public PointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, CartesianPointParser parser, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, (Explicit)builder.ignoreMalformed.get(), (Explicit)builder.ignoreZValue.get(), (AbstractPointGeometryFieldMapper.ParsedPoint)builder.nullValue.get(), copyTo, (AbstractGeometryFieldMapper.Parser)parser);
        this.builder = builder;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public PointFieldType fieldType() {
        return (PointFieldType)this.mappedFieldType;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value()).init((FieldMapper)this);
    }

    protected void index(ParseContext context, ParsedCartesianPoint point) throws IOException {
        if (this.fieldType().isSearchable()) {
            context.doc().add((IndexableField)new XYPointField(this.fieldType().name(), (float)point.getX(), (float)point.getY()));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new XYDocValuesField(this.fieldType().name(), (float)point.getX(), (float)point.getY()));
        } else if (this.fieldType().isStored() || this.fieldType().isSearchable()) {
            context.addFieldToFieldNamesField(this.fieldType().typeName());
        }
        if (this.fieldType().isStored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), point.toString()));
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)PointFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> (Boolean)PointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), (boolean)true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> (Boolean)PointFieldMapper.builder((FieldMapper)m).stored.get(), (boolean)false);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)PointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<AbstractPointGeometryFieldMapper.ParsedPoint> nullValue;
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)PointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), (boolean)ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> (AbstractPointGeometryFieldMapper.ParsedPoint)PointFieldMapper.builder((FieldMapper)m).nullValue.get(), (n, c, o) -> o == null ? null : Builder.parseNullValue(o, (Boolean)((Explicit)this.ignoreZValue.get()).value(), (Boolean)((Explicit)this.ignoreMalformed.get()).value()), () -> null).acceptsNull();
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.meta);
        }

        private static AbstractPointGeometryFieldMapper.ParsedPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            ParsedCartesianPoint point = new ParsedCartesianPoint();
            CartesianPoint.parsePoint((Object)nullValue, (CartesianPoint)point, (boolean)ignoreZValue);
            if (!ignoreMalformed) {
                if (!Double.isFinite(point.getX())) {
                    throw new IllegalArgumentException("illegal x value [" + point.getX() + "]");
                }
                if (!Double.isFinite(point.getY())) {
                    throw new IllegalArgumentException("illegal y value [" + point.getY() + "]");
                }
            }
            return point;
        }

        public FieldMapper build(ContentPath contentPath) {
            CartesianPointParser parser = new CartesianPointParser(this.name, (AbstractPointGeometryFieldMapper.ParsedPoint)this.nullValue.get(), (Boolean)((Explicit)this.ignoreZValue.get()).value(), (Boolean)((Explicit)this.ignoreMalformed.get()).value());
            PointFieldType ft = new PointFieldType(this.buildFullName(contentPath), (Boolean)this.indexed.get(), (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), parser, (Map)this.meta.get());
            return new PointFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), parser, this);
        }
    }

    public static class PointFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType
    implements ShapeQueryable {
        private final ShapeQueryPointProcessor queryProcessor = new ShapeQueryPointProcessor();

        private PointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, CartesianPointParser parser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, true, (AbstractGeometryFieldMapper.Parser)parser, meta);
        }

        public String typeName() {
            return PointFieldMapper.CONTENT_TYPE;
        }

        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.shapeQuery(shape, fieldName, relation, context);
        }
    }

    protected static class ParsedCartesianPoint
    extends CartesianPoint
    implements AbstractPointGeometryFieldMapper.ParsedPoint {
        protected ParsedCartesianPoint() {
        }

        public void validate(String fieldName) {
            if (!Double.isFinite(this.getX())) {
                throw new IllegalArgumentException("illegal x value [" + this.getX() + "] for " + fieldName);
            }
            if (!Double.isFinite(this.getY())) {
                throw new IllegalArgumentException("illegal y value [" + this.getY() + "] for " + fieldName);
            }
        }

        public void normalize(String fieldName) {
        }

        public void resetCoords(double x, double y) {
            this.reset(x, y);
        }

        public Point asGeometry() {
            return new Point(this.x, this.y);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof CartesianPoint)) {
                return false;
            }
            CartesianPoint o = (CartesianPoint)other;
            double oX = o.getX();
            double oY = o.getY();
            if (Double.compare(oX, this.x) != 0) {
                return false;
            }
            return Double.compare(oY, this.y) == 0;
        }
    }

    public static class CartesianPointParser
    extends AbstractPointGeometryFieldMapper.PointParser<ParsedCartesianPoint> {
        public CartesianPointParser(String name, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            super(name, ParsedCartesianPoint::new, (parser, point) -> {
                ParsedCartesianPoint.parsePoint((XContentParser)parser, (CartesianPoint)point, (boolean)ignoreZValue);
                return point;
            }, (AbstractPointGeometryFieldMapper.ParsedPoint)((ParsedCartesianPoint)nullValue), ignoreZValue, ignoreMalformed);
        }
    }
}

