/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.mapper;

import io.lucenia.geo.mapper.ShapeIndexer;
import io.lucenia.geo.search.query.ShapeQueryProcessor;
import io.skylite.common.Explicit;
import io.skylite.common.geometry.Geometry;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.ParseContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.opensearch.index.mapper.GeoShapeParser;
import org.opensearch.index.mapper.ShapeQueryable;

public class ShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    public static final String CONTENT_TYPE = "shape";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings()), (Boolean)COERCE_SETTING.get(c.getSettings())));
    private final Builder builder;
    private final ShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((ShapeFieldMapper)in).builder;
    }

    public ShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<Geometry> parser, Builder builder) {
        super(simpleName, mappedFieldType, (Explicit)builder.ignoreMalformed.get(), (Explicit)builder.coerce.get(), (Explicit)builder.ignoreZValue.get(), (Explicit)builder.orientation.get(), multiFields, copyTo, parser);
        this.builder = builder;
        this.indexer = new ShapeIndexer(simpleName);
    }

    protected void index(ParseContext context, Geometry geometry) throws IOException {
        context.doc().addAll(this.indexer.indexShape(geometry));
        context.addFieldToFieldNamesField(this.fieldType().name());
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ShapeFieldType fieldType() {
        return (ShapeFieldType)super.fieldType();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value(), (Boolean)((Explicit)this.builder.coerce.getDefaultValue()).value()).init((FieldMapper)this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)ShapeFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<ShapeBuilder.Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), (boolean)ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> (Explicit)ShapeFieldMapper.builder((FieldMapper)m).coerce.get(), (boolean)coerceByDefault);
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue.setValue((Object)new Explicit((Object)ignoreZValue, true));
            return this;
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.meta);
        }

        public ShapeFieldMapper build(ContentPath contentPath) {
            GeometryParser geometryParser = new GeometryParser(((ShapeBuilder.Orientation)((Explicit)this.orientation.get()).value()).getAsBoolean(), ((Boolean)((Explicit)this.coerce.get()).value()).booleanValue(), ((Boolean)((Explicit)this.ignoreZValue.get()).value()).booleanValue());
            GeoShapeParser parser = new GeoShapeParser(geometryParser);
            ShapeFieldType ft = new ShapeFieldType(this.buildFullName(contentPath), (Boolean)this.indexed.get(), (ShapeBuilder.Orientation)((Explicit)this.orientation.get()).value(), (AbstractGeometryFieldMapper.Parser<Geometry>)parser, (Map)this.meta.get());
            return new ShapeFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), (AbstractGeometryFieldMapper.Parser<Geometry>)parser, this);
        }
    }

    public static final class ShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType
    implements ShapeQueryable {
        private final ShapeQueryProcessor queryProcessor = new ShapeQueryProcessor();

        public ShapeFieldType(String name, boolean indexed, ShapeBuilder.Orientation orientation, AbstractGeometryFieldMapper.Parser<Geometry> parser, Map<String, String> meta) {
            super(name, indexed, false, false, false, parser, orientation, meta);
        }

        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.shapeQuery(shape, fieldName, relation, context);
        }

        public String typeName() {
            return ShapeFieldMapper.CONTENT_TYPE;
        }
    }
}

