/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.mapper;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.core.geo.ShapeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.index.IndexableField;

public class ShapeIndexer {
    private final String name;

    public ShapeIndexer(String name) {
        this.name = name;
    }

    public List<IndexableField> indexShape(Geometry shape) {
        LuceneGeometryVisitor visitor = new LuceneGeometryVisitor(this.name);
        shape.visit((GeometryVisitor)visitor);
        return visitor.fields;
    }

    private static class LuceneGeometryVisitor
    implements GeometryVisitor<Void, RuntimeException> {
        private List<IndexableField> fields = new ArrayList<IndexableField>();
        private String name;

        private LuceneGeometryVisitor(String name) {
            this.name = name;
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        public Void visit(Ellipse ellipse) {
            throw new IllegalArgumentException("invalid shape type found [Ellipse] while indexing shape");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYLine)ShapeUtils.toLuceneXYLine((Line)line)));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (float)((float)point.getX()), (float)((float)point.getY())));
            return null;
        }

        public Void visit(Polygon polygon) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYPolygon)ShapeUtils.toLuceneXYPolygon((Polygon)polygon)));
            return null;
        }

        public Void visit(Rectangle r) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYPolygon)ShapeUtils.toLuceneXYPolygon((Rectangle)r)));
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }
}

