/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.ShapeType;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.geo.CircleUtils;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MapXContentParser;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.opensearch.common.geo.GeometryParser;

public class CircleProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "circle";
    private final String field;
    private final String targetField;
    private final boolean ignoreMissing;
    private final double errorDistance;
    private final CircleShapeFieldType circleShapeFieldType;
    static final GeometryParser PARSER = new GeometryParser(true, true, true);

    CircleProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, double errorDistance, CircleShapeFieldType circleShapeFieldType) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.errorDistance = errorDistance;
        this.circleShapeFieldType = circleShapeFieldType;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        Object obj = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (obj == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (obj == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        if (!(obj instanceof Map) && !(obj instanceof String)) {
            throw new IllegalArgumentException("field [" + this.field + "] must be a WKT Circle or a GeoJSON Circle value");
        }
        Map<String, Object> valueWrapper = Map.of("shape", obj);
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, valueWrapper, MediaTypeRegistry.JSON);
        try {
            Polygon polygon;
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            GeometryFormat geometryFormat = PARSER.geometryFormat((XContentParser)parser);
            Geometry geometry = (Geometry)geometryFormat.fromXContent((XContentParser)parser);
            if (ShapeType.CIRCLE.equals((Object)geometry.type())) {
                Circle circle = (Circle)geometry;
                int numSides = CircleUtils.circleToPolygonNumSides((double)circle.getRadiusMeters(), (double)this.errorDistance);
                switch (this.circleShapeFieldType.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        polygon = CircleUtils.createRegularGeoShapePolygon((Circle)circle, (int)numSides);
                        break;
                    }
                    case 0: {
                        polygon = CircleUtils.createRegularShapePolygon((Circle)circle, (int)numSides);
                    }
                }
            } else {
                throw new IllegalArgumentException("found [" + String.valueOf(geometry.type()) + "] instead of circle");
            }
            Polygon polygonizedCircle = polygon;
            XContentBuilder newValueBuilder = MediaTypeRegistry.JSON.contentBuilder().startObject().field("val");
            geometryFormat.toXContent((Object)polygonizedCircle, newValueBuilder, ToXContent.EMPTY_PARAMS);
            newValueBuilder.endObject();
            Map newObj = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)newValueBuilder), (boolean)true, (MediaType)XContentType.JSON).v2();
            ingestDocument.setFieldValue(this.targetField, newObj.get("val"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid circle definition", e);
        }
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    String field() {
        return this.field;
    }

    String targetField() {
        return this.targetField;
    }

    double errorDistance() {
        return this.errorDistance;
    }

    CircleShapeFieldType shapeType() {
        return this.circleShapeFieldType;
    }

    static enum CircleShapeFieldType {
        SHAPE,
        GEO_SHAPE;


        public static CircleShapeFieldType parse(String value) {
            EnumSet<CircleShapeFieldType> validValues = EnumSet.allOf(CircleShapeFieldType.class);
            try {
                return CircleShapeFieldType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("illegal [shape_type] value [" + value + "]. valid values are " + Arrays.toString(validValues.toArray()));
            }
        }
    }

    public static final class Factory
    implements AbstractProcessor.Factory<CircleProcessor> {
        public CircleProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty((String)CircleProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)CircleProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)field);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)CircleProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            double radiusDistance = Math.abs(ConfigurationUtils.readDoubleProperty((String)CircleProcessor.TYPE, (String)processorTag, config, (String)"error_distance"));
            CircleShapeFieldType circleFieldType = CircleShapeFieldType.parse(ConfigurationUtils.readStringProperty((String)CircleProcessor.TYPE, (String)processorTag, config, (String)"shape_type"));
            return new CircleProcessor(processorTag, description, field, targetField, ignoreMissing, radiusDistance, circleFieldType);
        }
    }
}

