/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor.reprojection;

import io.lucenia.geo.processor.BaseGeometryIngestProcessor;
import io.lucenia.geo.processor.reprojection.BaseReprojectionProcessor;
import io.skylite.common.CheckedBiFunction;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.geographic.referencing.GeometryProcessorFieldType;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.geo.GeometryParser;

public class ReprojectionIngestProcessor
extends BaseReprojectionProcessor
implements BaseGeometryIngestProcessor {
    ReprojectionIngestProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, String fromCRS, String toCRS, double tolerance, GeometryProcessorFieldType shapeFieldType, Optional<String> crsProvider) {
        super(tag, description, field, targetField, ignoreMissing, fromCRS, toCRS, tolerance, shapeFieldType, crsProvider);
    }

    @Override
    public String sourceField() {
        return this.sourceField;
    }

    @Override
    public String targetField() {
        return this.targetField;
    }

    @Override
    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    public GeometryParser parser() {
        return PARSER;
    }

    @Override
    public CheckedBiFunction<Geometry, GeometryFormat, Geometry, Exception> processGeometry() {
        return this::processGeometry;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<ReprojectionIngestProcessor> {
        public ReprojectionIngestProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"target_field", (String)field);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            String srcCRS = ConfigurationUtils.readStringProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"source_crs");
            String trgtCRS = ConfigurationUtils.readOptionalStringProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"target_crs");
            double tolerance = ConfigurationUtils.readDoubleProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"tolerance", (double)0.01);
            GeometryProcessorFieldType shapeFieldType = GeometryProcessorFieldType.parse((String)ConfigurationUtils.readStringProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"shape_type", (String)GeometryProcessorFieldType.GEO_SHAPE.toString()));
            Optional<String> provider = Optional.ofNullable(ConfigurationUtils.readOptionalStringProperty((String)BaseReprojectionProcessor.TYPE.getPreferredName(), (String)processorTag, config, (String)"provider"));
            return new ReprojectionIngestProcessor(processorTag, description, field, targetField, ignoreMissing, srcCRS, trgtCRS, tolerance, shapeFieldType, provider);
        }
    }
}

