/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor.reprojection;

import io.lucenia.geo.processor.BaseGeometrySearchProcessor;
import io.lucenia.geo.processor.reprojection.BaseReprojectionProcessor;
import io.skylite.common.collect.Tuple;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.utils.WellKnownText;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ParseField;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchResponseProcessor;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MapXContentParser;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.geographic.referencing.GeometryProcessorFieldType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.geo.GeometryParser;

public class ReprojectionSearchResponseProcessor
extends BaseReprojectionProcessor
implements BaseGeometrySearchProcessor,
SearchResponseProcessor {
    protected ReprojectionSearchResponseProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, String fromCRS, String toCRS, double tolerance, GeometryProcessorFieldType shapeFieldType, Optional<String> crsProvider) {
        super(tag, description, field, targetField, ignoreMissing, fromCRS, toCRS, tolerance, shapeFieldType, crsProvider);
    }

    @Override
    public String sourceField() {
        return this.sourceField;
    }

    @Override
    public String targetField() {
        return this.targetField;
    }

    @Override
    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    public GeometryParser parser() {
        return PARSER;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        SearchHit[] hits;
        for (SearchHit hit : hits = response.getHits().getHits()) {
            Object geometryMap;
            BytesReference sourceRef;
            Tuple typeAndSourceMap;
            Map sourceAsMap;
            Map fields = hit.getFields();
            if (fields.containsKey(this.sourceField)) {
                // empty if block
            }
            if (!hit.hasSource() || !(sourceAsMap = (Map)(typeAndSourceMap = XContentHelper.convertToMap((BytesReference)(sourceRef = hit.getSourceRef()), (boolean)false, null)).v2()).containsKey(this.sourceField) || !((geometryMap = sourceAsMap.get(this.sourceField)) instanceof Map) && !(geometryMap instanceof String)) continue;
            Geometry inGeometry = this.parser().parseGeometry(geometryMap);
            MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap(ParseField.CommonFields.NULL_VALUE.getPreferredName(), geometryMap), MediaTypeRegistry.JSON);
            parser.nextToken();
            GeometryFormat format = this.parser().geometryFormat((XContentParser)parser);
            Geometry outGeometry = this.processGeometry(inGeometry, format);
            sourceAsMap.put(this.targetField, WellKnownText.INSTANCE.toWKT(outGeometry));
            XContentBuilder builder = XContentBuilder.builder((XContent)((MediaType)typeAndSourceMap.v1()).xContent());
            builder.map(sourceAsMap);
            hit.sourceRef(BytesReference.bytes((XContentBuilder)builder));
        }
        return response;
    }

    public static final class Factory
    extends BaseReprojectionProcessor.Factory<ReprojectionSearchResponseProcessor>
    implements SearchProcessor.Factory<ReprojectionSearchResponseProcessor> {
        @Override
        public ReprojectionSearchResponseProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, boolean ignoreMissing, Map<String, Object> config, String field, String targetField, String srcCRS, String trgtCRS, double tolerance, GeometryProcessorFieldType shapeFieldType, Optional<String> provider) {
            return new ReprojectionSearchResponseProcessor(processorTag, description, field, targetField, ignoreMissing, srcCRS, trgtCRS, tolerance, shapeFieldType, provider);
        }

        public ReprojectionSearchResponseProcessor create(Map<String, SearchProcessor.Factory<ReprojectionSearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, SearchProcessor.PipelineContext pipelineContext) throws Exception {
            return (ReprojectionSearchResponseProcessor)this.create(null, tag, description, config);
        }
    }
}

