/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.geogrid;

import io.skylite.SkyliteException;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.geo.GeoBoundingBox;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.xcontent.AbstractObjectParser;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.opensearch.search.aggregations.bucket.BucketUtils;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public abstract class GeoGridAggregationBuilder
extends ValuesSourceAggregationBuilder<GeoGridAggregationBuilder> {
    static final ParseField FIELD_PRECISION = new ParseField("precision", new String[0]);
    static final ParseField FIELD_SIZE = new ParseField("size", new String[0]);
    static final ParseField FIELD_SHARD_SIZE = new ParseField("shard_size", new String[0]);
    protected int precision;
    protected int requiredSize;
    protected int shardSize;
    private GeoBoundingBox geoBoundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));

    public static <T extends GeoGridAggregationBuilder> ObjectParser<T, String> createParser(String name, PrecisionParser precisionParser, Function<String, T> ctor) {
        ObjectParser parser = ObjectParser.fromBuilder((String)name, ctor);
        ValuesSourceAggregationBuilder.declareFields((AbstractObjectParser)parser, (boolean)false, (boolean)false, (boolean)false);
        parser.declareField((p, builder, context) -> builder.precision(precisionParser.parse(p)), FIELD_PRECISION, ObjectParser.ValueType.INT);
        parser.declareInt(GeoGridAggregationBuilder::size, FIELD_SIZE);
        parser.declareInt(GeoGridAggregationBuilder::shardSize, FIELD_SHARD_SIZE);
        parser.declareField((p, builder, context) -> builder.setGeoBoundingBox(GeoBoundingBox.parseBoundingBox((XContentParser)p)), GeoBoundingBox.BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        return parser;
    }

    public GeoGridAggregationBuilder(String name) {
        super(name);
    }

    protected GeoGridAggregationBuilder(GeoGridAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder)clone, factoriesBuilder, metadata);
        this.precision = clone.precision;
        this.requiredSize = clone.requiredSize;
        this.shardSize = clone.shardSize;
        this.geoBoundingBox = clone.geoBoundingBox;
    }

    public GeoGridAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.precision = in.readVInt();
        this.requiredSize = in.readVInt();
        this.shardSize = in.readVInt();
        this.geoBoundingBox = new GeoBoundingBox(in);
    }

    protected ValuesSourceType defaultValueSourceType() {
        return GeoValuesSourceType.GEOPOINT;
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.precision);
        out.writeVInt(this.requiredSize);
        out.writeVInt(this.shardSize);
        this.geoBoundingBox.writeTo(out);
    }

    public abstract GeoGridAggregationBuilder precision(int var1);

    protected abstract ValuesSourceAggregatorFactory createFactory(String var1, ValuesSourceConfig var2, int var3, int var4, int var5, GeoBoundingBox var6, AggregationContext var7, AggregatorFactory var8, AggregatorFactories.Builder var9, Map<String, Object> var10) throws IOException;

    public int precision() {
        return this.precision;
    }

    public GeoGridAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.requiredSize = size;
        return this;
    }

    public int size() {
        return this.requiredSize;
    }

    public GeoGridAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public int shardSize() {
        return this.shardSize;
    }

    public GeoGridAggregationBuilder setGeoBoundingBox(GeoBoundingBox geoBoundingBox) {
        this.geoBoundingBox = geoBoundingBox;
        return this;
    }

    public GeoBoundingBox geoBoundingBox() {
        return this.geoBoundingBox;
    }

    public final AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        int shardSize = this.shardSize;
        int requiredSize = this.requiredSize;
        if (shardSize < 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize((int)requiredSize);
        }
        if (requiredSize <= 0 || shardSize <= 0) {
            throw new SkyliteException("parameters [required_size] and [shard_size] must be > 0 in " + this.getType() + " aggregation [" + this.name + "].", new Object[0]);
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        return this.createFactory(this.name, config, this.precision, requiredSize, shardSize, this.geoBoundingBox, context, parent, subFactoriesBuilder, this.metadata);
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELD_PRECISION.getPreferredName(), this.precision);
        builder.field(FIELD_SIZE.getPreferredName(), this.requiredSize);
        if (this.shardSize > -1) {
            builder.field(FIELD_SHARD_SIZE.getPreferredName(), this.shardSize);
        }
        if (!this.geoBoundingBox.isUnbounded()) {
            this.geoBoundingBox.toXContent(builder, params);
        }
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoGridAggregationBuilder other = (GeoGridAggregationBuilder)((Object)obj);
        return this.precision == other.precision && this.requiredSize == other.requiredSize && this.shardSize == other.shardSize && Objects.equals(this.geoBoundingBox, other.geoBoundingBox);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.requiredSize, this.shardSize, this.geoBoundingBox);
    }

    @FunctionalInterface
    protected static interface PrecisionParser {
        public int parse(XContentParser var1) throws IOException;
    }
}

