/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.geogrid.cells;

import io.lucenia.geo.search.aggregations.bucket.geogrid.cells.BoundedCellValues;
import io.lucenia.geo.search.aggregations.bucket.geogrid.cells.UnboundedCellValues;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.geo.GeoBoundingBox;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;

public class CellIdSource
extends NumericValuesSource {
    private final GeoPointValuesSource valuesSource;
    private final int precision;
    private final GeoPointLongEncoder encoder;
    private final GeoBoundingBox geoBoundingBox;

    public CellIdSource(GeoPointValuesSource valuesSource, int precision, GeoBoundingBox geoBoundingBox, GeoPointLongEncoder encoder) {
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.geoBoundingBox = geoBoundingBox;
        this.encoder = encoder;
    }

    public int precision() {
        return this.precision;
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public boolean isBigInteger() {
        return false;
    }

    public SortedNumericDocValues longValues(LeafReaderContext ctx) {
        if (this.geoBoundingBox.isUnbounded()) {
            return new UnboundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.encoder);
        }
        return new BoundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.encoder, this.geoBoundingBox);
    }

    public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    public static interface GeoPointLongEncoder {
        public long encode(double var1, double var3, int var5);
    }
}

