/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.geogrid.cells;

import io.lucenia.geo.search.aggregations.bucket.geogrid.cells.GeoShapeCellValues;
import io.skylite.core.aggregations.values.GeoShapeValuesSource;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.geo.GeoBoundingBox;
import io.skylite.core.geo.GeoShapeDocValue;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;

public class GeoShapeCellIdSource
extends NumericValuesSource {
    private final GeoShapeValuesSource geoShape;
    private final int precision;
    private final GeoBoundingBox geoBoundingBox;
    private final GeoShapeLongEncoder encoder;

    public GeoShapeCellIdSource(GeoShapeValuesSource geoShape, int precision, GeoBoundingBox geoBoundingBox, GeoShapeLongEncoder encoder) {
        this.geoShape = geoShape;
        this.geoBoundingBox = geoBoundingBox;
        this.precision = precision;
        this.encoder = encoder;
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("The bytesValues operation is not supported on GeoShapeCellIdSource");
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public boolean isBigInteger() {
        return false;
    }

    public SortedNumericDocValues longValues(LeafReaderContext context) {
        if (this.geoBoundingBox.isUnbounded()) {
            return new GeoShapeCellValues.UnboundedCellValues(this.geoShape.getGeoShapeValues(context), this.precision, this.encoder);
        }
        return new GeoShapeCellValues.BoundedCellValues(this.geoShape.getGeoShapeValues(context), this.precision, this.encoder, this.geoBoundingBox);
    }

    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) {
        throw new UnsupportedOperationException("The doubleValues operation is not supported on GeoShapeCellIdSource");
    }

    @FunctionalInterface
    public static interface GeoShapeLongEncoder {
        public List<Long> encode(GeoShapeDocValue var1, int var2);
    }
}

