/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.geogrid.util;

import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.utils.Geohash;
import io.skylite.core.geo.GeoShapeDocValue;
import java.util.ArrayList;
import java.util.List;

public class GeoShapeHashUtil {
    public static List<Long> encodeShape(GeoShapeDocValue geoShapeDocValue, int precision) {
        ArrayList<Long> encodedValues = new ArrayList<Long>();
        GeoShapeDocValue.BoundingRectangle boundingRectangle = geoShapeDocValue.getBoundingRectangle();
        long topLeftGeoHash = Geohash.longEncode((double)boundingRectangle.getMinX(), (double)boundingRectangle.getMaxY(), (int)precision);
        long topRightGeoHash = Geohash.longEncode((double)boundingRectangle.getMaxX(), (double)boundingRectangle.getMaxY(), (int)precision);
        long bottomRightGeoHash = Geohash.longEncode((double)boundingRectangle.getMaxX(), (double)boundingRectangle.getMinY(), (int)precision);
        long currentValue = topLeftGeoHash;
        long rightMax = topRightGeoHash;
        long tempCurrent = currentValue;
        while (true) {
            Rectangle geohashRectangle;
            if (geoShapeDocValue.isIntersectingRectangle(geohashRectangle = Geohash.toBoundingBox((String)Geohash.stringEncode((long)tempCurrent)))) {
                encodedValues.add(tempCurrent);
            }
            if (tempCurrent == bottomRightGeoHash) break;
            if (tempCurrent == rightMax) {
                currentValue = tempCurrent = Geohash.longEncode((String)Geohash.getNeighbor((String)Geohash.stringEncode((long)currentValue), (int)precision, (int)0, (int)-1));
                rightMax = Geohash.longEncode((String)Geohash.getNeighbor((String)Geohash.stringEncode((long)rightMax), (int)precision, (int)0, (int)-1));
                continue;
            }
            tempCurrent = Geohash.longEncode((String)Geohash.getNeighbor((String)Geohash.stringEncode((long)tempCurrent), (int)precision, (int)1, (int)0));
        }
        return encodedValues;
    }
}

