/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.metrics;

import io.lucenia.geo.search.aggregations.metrics.AbstractGeoBoundsAggregator;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.GeoShapeValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.geo.GeoShapeDocValue;
import io.skylite.core.index.fielddata.geo.GeoShapeValue;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;

public final class GeoBoundsGeoShapeAggregator
extends AbstractGeoBoundsAggregator<GeoShapeValuesSource> {
    private static final Logger LOGGER = LogManager.getLogger(GeoBoundsGeoShapeAggregator.class);

    public GeoBoundsGeoShapeAggregator(String name, SearchExecutionContext searchContext, Aggregator aggregator, ValuesSourceConfig valuesSourceConfig, boolean wrapLongitude, Map<String, Object> metaData) throws IOException {
        super(name, searchContext, aggregator, valuesSourceConfig, wrapLongitude, metaData);
    }

    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector leafBucketCollector) {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final GeoShapeValue values = ((GeoShapeValuesSource)this.valuesSource).getGeoShapeValues(ctx);
        return new LeafBucketCollectorBase(leafBucketCollector, values){

            public void collect(int doc, long bucket) throws IOException {
                GeoBoundsGeoShapeAggregator.this.setBucketSize(bucket, bigArrays);
                if (values.advanceExact(doc)) {
                    GeoShapeDocValue value = values.nextValue();
                    GeoShapeDocValue.BoundingRectangle boundingBox = value.getBoundingRectangle();
                    if (boundingBox != null) {
                        double top = GeoBoundsGeoShapeAggregator.this.tops.get(bucket);
                        if (boundingBox.getMaxLatitude() > top) {
                            top = boundingBox.getMaxLatitude();
                        }
                        double bottom = GeoBoundsGeoShapeAggregator.this.bottoms.get(bucket);
                        if (boundingBox.getMinLatitude() < bottom) {
                            bottom = boundingBox.getMinLatitude();
                        }
                        double posLeft = GeoBoundsGeoShapeAggregator.this.posLefts.get(bucket);
                        if (boundingBox.getMinLongitude() >= 0.0 && boundingBox.getMinLongitude() < posLeft) {
                            posLeft = boundingBox.getMinLongitude();
                        }
                        if (boundingBox.getMaxLongitude() >= 0.0 && boundingBox.getMaxLongitude() < posLeft) {
                            posLeft = boundingBox.getMaxLongitude();
                        }
                        double posRight = GeoBoundsGeoShapeAggregator.this.posRights.get(bucket);
                        if (boundingBox.getMaxLongitude() >= 0.0 && boundingBox.getMaxLongitude() > posRight) {
                            posRight = boundingBox.getMaxLongitude();
                        }
                        if (boundingBox.getMinLongitude() >= 0.0 && boundingBox.getMinLongitude() > posRight) {
                            posRight = boundingBox.getMinLongitude();
                        }
                        double negLeft = GeoBoundsGeoShapeAggregator.this.negLefts.get(bucket);
                        if (boundingBox.getMinLongitude() < 0.0 && boundingBox.getMinLongitude() < negLeft) {
                            negLeft = boundingBox.getMinLongitude();
                        }
                        if (boundingBox.getMaxLongitude() < 0.0 && boundingBox.getMaxLongitude() < negLeft) {
                            negLeft = boundingBox.getMaxLongitude();
                        }
                        double negRight = GeoBoundsGeoShapeAggregator.this.negRights.get(bucket);
                        if (boundingBox.getMaxLongitude() < 0.0 && boundingBox.getMaxLongitude() > negRight) {
                            negRight = boundingBox.getMaxLongitude();
                        }
                        if (boundingBox.getMinLongitude() < 0.0 && boundingBox.getMinLongitude() > negRight) {
                            negRight = boundingBox.getMinLongitude();
                        }
                        GeoBoundsGeoShapeAggregator.this.tops.set(bucket, top);
                        GeoBoundsGeoShapeAggregator.this.bottoms.set(bucket, bottom);
                        GeoBoundsGeoShapeAggregator.this.posLefts.set(bucket, posLeft);
                        GeoBoundsGeoShapeAggregator.this.posRights.set(bucket, posRight);
                        GeoBoundsGeoShapeAggregator.this.negLefts.set(bucket, negLeft);
                        GeoBoundsGeoShapeAggregator.this.negRights.set(bucket, negRight);
                    } else {
                        LOGGER.error("The bounding box was null for the Doc id {}", (Object)doc);
                    }
                }
            }
        };
    }
}

