/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.query;

import io.lucenia.geo.mapper.PointFieldMapper;
import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.ShapeType;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.geo.ShapeUtils;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;

public class ShapeQueryPointProcessor {
    public Query shapeQuery(Geometry shape, String field, ShapeRelation relation, QueryShardContext context) {
        MappedFieldType fieldType = context.getFieldType(field);
        this.validateIsPointFieldType(field, fieldType, context);
        return switch (relation) {
            case ShapeRelation.INTERSECTS -> this.getVectorQueryFromShape(shape, field, relation, fieldType, context);
            case ShapeRelation.DISJOINT -> this.getDisjointQuery(shape, field, fieldType, context);
            default -> throw new QueryShardException(context.index(), "Spatial relation [" + String.valueOf(relation) + "] not supported for Field [" + field + "].", new Object[0]);
        };
    }

    protected Query getDisjointQuery(Geometry queryShape, String field, MappedFieldType fieldType, QueryShardContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (fieldType.hasDocValues()) {
            builder.add((Query)new FieldExistsQuery(field), BooleanClause.Occur.FILTER);
        } else {
            builder.add(this.getVectorQueryFromShape((Geometry)new Rectangle(-3.4028234663852886E38, 3.4028234663852886E38, -3.4028234663852886E38, 3.4028234663852886E38), field, ShapeRelation.INTERSECTS, fieldType, context), BooleanClause.Occur.FILTER);
        }
        builder.add(this.getVectorQueryFromShape(queryShape, field, ShapeRelation.INTERSECTS, fieldType, context), BooleanClause.Occur.MUST_NOT);
        return builder.build();
    }

    public Query getVectorQueryFromShape(Geometry queryShape, String field, ShapeRelation relation, MappedFieldType fieldType, QueryShardContext context) {
        ShapeVisitor visitor = new ShapeVisitor(this, field, relation, fieldType, context);
        return (Query)queryShape.visit((GeometryVisitor)visitor);
    }

    private void validateIsPointFieldType(String fieldName, MappedFieldType fieldType, QueryShardContext context) {
        if (!(fieldType instanceof PointFieldMapper.PointFieldType)) {
            throw new QueryShardException(context.index(), "Expected field type [point] for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        final String field;
        final ShapeRelation relation;
        final QueryShardContext context;
        final MappedFieldType fieldType;

        public ShapeVisitor(ShapeQueryPointProcessor shapeQueryPointProcessor, String field, ShapeRelation relation, MappedFieldType fieldType, QueryShardContext context) {
            this.field = field;
            this.relation = relation;
            this.context = context;
            this.fieldType = fieldType;
        }

        public Query visit(Circle circle) throws RuntimeException {
            XYCircle xyCircle = ShapeUtils.toLuceneXYCircle((Circle)circle);
            Query query = XYPointField.newDistanceQuery((String)this.field, (float)xyCircle.getX(), (float)xyCircle.getY(), (float)xyCircle.getRadius());
            if (this.fieldType.hasDocValues()) {
                Query docValuesQuery = XYDocValuesField.newSlowDistanceQuery((String)this.field, (float)xyCircle.getX(), (float)xyCircle.getY(), (float)xyCircle.getRadius());
                query = new IndexOrDocValuesQuery(query, docValuesQuery);
            }
            return query;
        }

        public Query visit(Ellipse ellipse) throws RuntimeException {
            throw new IllegalArgumentException("query on ellipse geometries not yet supported");
        }

        public Query visit(GeometryCollection<?> collection) throws RuntimeException {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        public Query visit(Line line) throws RuntimeException {
            throw new QueryShardException(this.context.index(), "Field [" + this.field + "] does not support " + String.valueOf(ShapeType.LINESTRING) + " queries", new Object[0]);
        }

        public Query visit(LinearRing ring) throws RuntimeException {
            throw new QueryShardException(this.context.index(), "Field [" + this.field + "] does not support " + String.valueOf(ShapeType.LINEARRING) + " queries", new Object[0]);
        }

        public Query visit(MultiLine multiLine) throws RuntimeException {
            throw new QueryShardException(this.context.index(), "Field [" + this.field + "] does not support " + String.valueOf(ShapeType.MULTILINESTRING) + " queries", new Object[0]);
        }

        public Query visit(MultiPoint multiPoint) throws RuntimeException {
            throw new QueryShardException(this.context.index(), "Field [" + this.field + "] does not support " + String.valueOf(ShapeType.MULTIPOINT) + " queries", new Object[0]);
        }

        public Query visit(MultiPolygon multiPolygon) throws RuntimeException {
            XYPolygon[] xyPolygons = new XYPolygon[multiPolygon.size()];
            for (int i = 0; i < xyPolygons.length; ++i) {
                xyPolygons[i] = ShapeUtils.toLuceneXYPolygon((Polygon)((Polygon)multiPolygon.get(i)));
            }
            Query q = XYPointField.newPolygonQuery((String)this.field, (XYPolygon[])xyPolygons);
            if (this.fieldType.hasDocValues()) {
                Query docValuesQuery = XYDocValuesField.newSlowPolygonQuery((String)this.field, (XYPolygon[])xyPolygons);
                q = new IndexOrDocValuesQuery(q, docValuesQuery);
            }
            return q;
        }

        public Query visit(Point point) throws RuntimeException {
            throw new QueryShardException(this.context.index(), "Field [" + this.field + "] does not support " + String.valueOf(ShapeType.POINT) + " queries", new Object[0]);
        }

        public Query visit(Polygon polygon) throws RuntimeException {
            XYPolygon xyPolygon = ShapeUtils.toLuceneXYPolygon((Polygon)polygon);
            Query q = XYPointField.newPolygonQuery((String)this.field, (XYPolygon[])new XYPolygon[]{xyPolygon});
            if (this.fieldType.hasDocValues()) {
                Query docValuesQuery = XYDocValuesField.newSlowPolygonQuery((String)this.field, (XYPolygon[])new XYPolygon[]{xyPolygon});
                q = new IndexOrDocValuesQuery(q, docValuesQuery);
            }
            return q;
        }

        public Query visit(Rectangle rectangle) throws RuntimeException {
            XYRectangle xyRectangle = ShapeUtils.toLuceneXYRectangle((Rectangle)rectangle);
            Query q = XYPointField.newBoxQuery((String)this.field, (float)xyRectangle.minX, (float)xyRectangle.maxX, (float)xyRectangle.minY, (float)xyRectangle.maxY);
            if (this.fieldType.hasDocValues()) {
                Query docValuesQuery = XYDocValuesField.newSlowBoxQuery((String)this.field, (float)xyRectangle.minX, (float)xyRectangle.maxX, (float)xyRectangle.minY, (float)xyRectangle.maxY);
                q = new IndexOrDocValuesQuery(q, docValuesQuery);
            }
            return q;
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            BooleanClause.Occur occur = BooleanClause.Occur.FILTER;
            for (Geometry shape : collection) {
                bqb.add((Query)shape.visit((GeometryVisitor)this), occur);
            }
        }
    }
}

