/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.query;

import io.lucenia.geo.mapper.ShapeFieldMapper;
import io.skylite.LegacyESVersion;
import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.geo.ShapeUtils;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public class ShapeQueryProcessor {
    public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        this.validateIsShapeFieldType(fieldName, context);
        if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(LegacyESVersion.fromId((int)750099))) {
            throw new QueryShardException(context.index(), String.valueOf(ShapeRelation.CONTAINS) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        if (shape == null) {
            return new MatchNoDocsQuery();
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private void validateIsShapeFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.getFieldType(fieldName);
        if (!(fieldType instanceof ShapeFieldMapper.ShapeFieldType)) {
            throw new QueryShardException(context.index(), "Expected shape field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    private Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        LuceneGeometryCollector visitor = new LuceneGeometryCollector(fieldName, context);
        queryShape.visit((GeometryVisitor)visitor);
        List<XYGeometry> geometries = visitor.geometries();
        if (geometries.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return XYShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (XYGeometry[])geometries.toArray(new XYGeometry[geometries.size()]));
    }

    private static class LuceneGeometryCollector
    implements GeometryVisitor<Void, RuntimeException> {
        private final List<XYGeometry> geometries = new ArrayList<XYGeometry>();
        private final String name;
        private final QueryShardContext context;

        private LuceneGeometryCollector(String name, QueryShardContext context) {
            this.name = name;
            this.context = context;
        }

        List<XYGeometry> geometries() {
            return this.geometries;
        }

        public Void visit(Circle circle) {
            if (!circle.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYCircle((Circle)circle));
            }
            return null;
        }

        public Void visit(Ellipse ellipse) {
            throw new IllegalArgumentException("Querying with Ellipse geometries not yet supported");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                shape.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            if (!line.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYLine((Line)line));
            }
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new QueryShardException(this.context.index(), "Field [" + this.name + "] found and unsupported shape LinearRing", new Object[0]);
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            if (!point.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYPoint((Point)point));
            }
            return null;
        }

        public Void visit(Polygon polygon) {
            if (!polygon.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYPolygon((Polygon)polygon));
            }
            return null;
        }

        public Void visit(Rectangle r) {
            if (!r.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYRectangle((Rectangle)r));
            }
            return null;
        }
    }
}

