/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.gcs;

import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.ReloadablePlugin;
import io.lucenia.plugins.RepositoryPlugin;
import io.lucenia.repositories.gcs.GoogleCloudStorageClientSettings;
import io.lucenia.repositories.gcs.GoogleCloudStorageRepository;
import io.lucenia.repositories.gcs.GoogleCloudStorageService;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.env.Environment;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.repositories.Repository;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GoogleCloudStoragePlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    final GoogleCloudStorageService storageService = this.createStorageService();

    public GoogleCloudStoragePlugin(Settings settings) {
        this.reload(settings);
    }

    protected GoogleCloudStorageService createStorageService() {
        return new GoogleCloudStorageService();
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("gcs", metadata -> new GoogleCloudStorageRepository(metadata, namedXContentRegistry, this.storageService, clusterService, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(GoogleCloudStorageClientSettings.CREDENTIALS_FILE_SETTING, GoogleCloudStorageClientSettings.ENDPOINT_SETTING, GoogleCloudStorageClientSettings.PROJECT_ID_SETTING, GoogleCloudStorageClientSettings.CONNECT_TIMEOUT_SETTING, GoogleCloudStorageClientSettings.READ_TIMEOUT_SETTING, GoogleCloudStorageClientSettings.APPLICATION_NAME_SETTING, GoogleCloudStorageClientSettings.TOKEN_URI_SETTING, GoogleCloudStorageClientSettings.PROXY_TYPE_SETTING, GoogleCloudStorageClientSettings.PROXY_HOST_SETTING, GoogleCloudStorageClientSettings.PROXY_PORT_SETTING, GoogleCloudStorageClientSettings.PROXY_USERNAME_SETTING, GoogleCloudStorageClientSettings.PROXY_PASSWORD_SETTING);
    }

    public void reload(Settings settings) {
        Map<String, GoogleCloudStorageClientSettings> clientsSettings = GoogleCloudStorageClientSettings.load(settings);
        this.storageService.refreshAndClearCache(clientsSettings);
    }
}

