/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.util;

import java.sql.DatabaseMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class SQLUtilities
extends Static {
    private SQLUtilities() {
    }

    public static String getSimplifiedURL(DatabaseMetaData metadata) throws SQLException {
        int s2;
        String url = metadata.getURL();
        int s1 = url.indexOf(63);
        if (s1 < 0) {
            s1 = url.length();
        }
        if ((s2 = url.indexOf(59)) < 0) {
            s2 = url.length();
        }
        return url.substring(0, Math.min(s1, s2));
    }

    public static Boolean parseBoolean(String text) throws SQLException {
        if (text == null) {
            return null;
        }
        switch (text.length()) {
            case 0: {
                return null;
            }
            case 1: {
                switch (text.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                    case '1': 
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                }
                break;
            }
            default: {
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("yes")) {
                    return Boolean.TRUE;
                }
                if (!text.equalsIgnoreCase("false") && !text.equalsIgnoreCase("no")) break;
                return Boolean.FALSE;
            }
        }
        throw new SQLDataException(Errors.format((short)8, (Object)text, Boolean.class));
    }

    public static String escape(String pattern, String escape) {
        if (pattern != null) {
            StringBuilder buffer = null;
            int i = pattern.length();
            while (--i >= 0) {
                char c = pattern.charAt(i);
                if (c != '_' && c != '%') continue;
                if (buffer == null) {
                    buffer = new StringBuilder(pattern);
                }
                buffer.insert(i, escape);
            }
            if (buffer != null) {
                return buffer.toString();
            }
        }
        return pattern;
    }

    public static void toLikePattern(String identifier, int i, int end, boolean allowSuffix, boolean toLower, StringBuilder buffer) {
        int bs = buffer.length();
        while (i < end) {
            int c = identifier.codePointAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (c < 128) {
                    buffer.appendCodePoint(toLower ? Character.toLowerCase(c) : c);
                } else {
                    SQLUtilities.appendIfNotRedundant(buffer, '_');
                }
            } else {
                int length = buffer.length();
                if (length == bs) {
                    buffer.appendCodePoint(c != 37 ? c : 95);
                } else if (buffer.charAt(length - 1) != '%') {
                    buffer.append('%');
                }
            }
            i += Character.charCount(c);
        }
        if (allowSuffix) {
            SQLUtilities.appendIfNotRedundant(buffer, '%');
        }
        i = bs;
        while ((i = buffer.indexOf("_%", i)) >= 0) {
            buffer.deleteCharAt(i);
        }
    }

    private static void appendIfNotRedundant(StringBuilder buffer, char wildcard) {
        int length = buffer.length();
        if (length == 0 || buffer.charAt(length - 1) != '%') {
            buffer.append(wildcard);
        }
    }

    public static boolean filterFalsePositive(String expected, String actual) {
        return CharSequences.equalsFiltered((CharSequence)expected, (CharSequence)actual, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)false);
    }
}

