/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.UUID;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Locales;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.xml.LegacyCodes;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.XPointer;

public class ValueConverter {
    public static final ValueConverter DEFAULT = new ValueConverter();

    protected ValueConverter() {
    }

    protected <T> boolean exceptionOccured(MarshalContext context, T value, Class<T> sourceType, Class<?> targetType, Exception exception) {
        return false;
    }

    public String toLanguageCode(MarshalContext context, Locale value) throws MissingResourceException {
        if (value != null) {
            String code;
            try {
                code = value.getISO3Language();
            }
            catch (MissingResourceException e) {
                if (!this.exceptionOccured(context, value, Locale.class, String.class, e)) {
                    throw e;
                }
                code = value.getLanguage();
            }
            if (!code.isEmpty()) {
                return code;
            }
        }
        return null;
    }

    public String toCountryCode(MarshalContext context, Locale value) throws MissingResourceException {
        String code;
        if (value != null && !(code = value.getCountry()).isEmpty()) {
            return code;
        }
        return null;
    }

    public String toCharsetCode(MarshalContext context, Charset value) {
        if (value != null) {
            return LegacyCodes.fromIANA(value.name());
        }
        return null;
    }

    public Locale toLocale(MarshalContext context, String value) throws IllformedLocaleException {
        block3: {
            if ((value = Strings.trimOrNull((String)value)) != null) {
                try {
                    return Locales.parse((String)value);
                }
                catch (IllformedLocaleException e) {
                    if (this.exceptionOccured(context, value, String.class, Locale.class, e)) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    public Charset toCharset(MarshalContext context, String value) throws IllegalCharsetNameException {
        block3: {
            if ((value = Strings.trimOrNull((String)value)) != null) {
                value = LegacyCodes.toIANA(value);
                try {
                    return Charset.forName(value);
                }
                catch (IllegalCharsetNameException e) {
                    if (this.exceptionOccured(context, value, String.class, Charset.class, e)) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    public Unit<?> toUnit(MarshalContext context, String value) throws IllegalArgumentException {
        block4: {
            if ((value = Strings.trimOrNull((String)value)) != null) {
                try {
                    String anchor;
                    int endOfURI = XPointer.endOfURI(value, 0);
                    if (endOfURI > 0 && (anchor = XPointer.UOM.reference(value.substring(0, endOfURI))) != null) {
                        value = anchor;
                    }
                    return Units.valueOf((String)value);
                }
                catch (MeasurementParseException e) {
                    if (this.exceptionOccured(context, value, String.class, Unit.class, (Exception)((Object)e))) break block4;
                    throw e;
                }
            }
        }
        return null;
    }

    public UUID toUUID(MarshalContext context, String value) throws IllegalArgumentException {
        block3: {
            if ((value = Strings.trimOrNull((String)value)) != null) {
                try {
                    return UUID.fromString(value);
                }
                catch (IllegalArgumentException e) {
                    if (this.exceptionOccured(context, value, String.class, UUID.class, e)) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    public URI toURI(MarshalContext context, String value) throws URISyntaxException {
        block3: {
            if ((value = Strings.trimOrNull((String)value)) != null) {
                try {
                    return new URI(value);
                }
                catch (URISyntaxException e) {
                    if (this.exceptionOccured(context, value, String.class, URI.class, e)) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    public URI toURI(MarshalContext context, URL value) throws URISyntaxException {
        block3: {
            if (value != null) {
                try {
                    return value.toURI();
                }
                catch (URISyntaxException e) {
                    if (this.exceptionOccured(context, value, URL.class, URI.class, e)) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    public URL toURL(MarshalContext context, URI value) throws MalformedURLException {
        block3: {
            if (value != null) {
                try {
                    return value.toURL();
                }
                catch (IllegalArgumentException | MalformedURLException e) {
                    if (this.exceptionOccured(context, value, URI.class, URL.class, e)) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    public NilReason toNilReason(MarshalContext context, String value) throws URISyntaxException {
        block3: {
            if ((value = Strings.trimOrNull((String)value)) != null) {
                try {
                    return NilReason.valueOf(value);
                }
                catch (URISyntaxException e) {
                    if (this.exceptionOccured(context, value, String.class, URI.class, e)) break block3;
                    throw e;
                }
            }
        }
        return null;
    }
}

