/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.agent;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public final class MLMemorySpec
implements ToXContentObject {
    public static final String MEMORY_TYPE_FIELD = "type";
    public static final String WINDOW_SIZE_FIELD = "window_size";
    public static final String SESSION_ID_FIELD = "session_id";
    private final String type;
    private final String sessionId;
    private final int windowSize;

    public MLMemorySpec(String type, String sessionId, int windowSize) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.type = type;
        this.sessionId = sessionId;
        this.windowSize = windowSize;
    }

    public MLMemorySpec(StreamInput input) throws IOException {
        this.type = input.readString();
        this.sessionId = input.readOptionalString();
        this.windowSize = input.readOptionalInt();
    }

    public String getType() {
        return this.type;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeOptionalString(this.sessionId);
        out.writeOptionalInt(this.windowSize == -1 ? null : Integer.valueOf(this.windowSize));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MEMORY_TYPE_FIELD, this.type);
        if (this.windowSize != -1) {
            builder.field(WINDOW_SIZE_FIELD, this.windowSize);
        }
        if (this.sessionId != null) {
            builder.field(SESSION_ID_FIELD, this.sessionId);
        }
        builder.endObject();
        return builder;
    }

    public static MLMemorySpec parse(XContentParser parser) throws IOException {
        String type = null;
        String sessionId = null;
        Integer windowSize = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block10;
                }
                case "session_id": {
                    sessionId = parser.text();
                    continue block10;
                }
                case "window_size": {
                    windowSize = parser.intValue();
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new MLMemorySpec(type, sessionId, windowSize);
    }

    public static MLMemorySpec fromStream(StreamInput in) throws IOException {
        return new MLMemorySpec(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLMemorySpec that = (MLMemorySpec)o;
        return this.windowSize == that.windowSize && Objects.equals(this.type, that.type) && Objects.equals(this.sessionId, that.sessionId);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.sessionId != null ? this.sessionId.hashCode() : 0);
        result = 31 * result + this.windowSize;
        return result;
    }

    public String toString() {
        return "MLMemorySpec[type=" + this.type + (String)(this.sessionId != null ? ", sessionId=" + this.sessionId : "") + (String)(this.windowSize != -1 ? ", windowSize=" + this.windowSize : "") + "]";
    }

    public static final class Builder {
        private String type;
        private String sessionId;
        private int windowSize;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder windowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public MLMemorySpec build() {
            return new MLMemorySpec(this.type, this.sessionId, this.windowSize);
        }
    }
}

