/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.algorithms.anomalylocalization;

import io.skylite.common.util.Counter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HashMapCounter
implements Counter {
    private Map<List<String>, Double> keyValues = new HashMap<List<String>, Double>();

    public void increment(List<String> key, double value) {
        this.keyValues.compute(key, (k, v) -> v == null ? value : value + v);
    }

    public double estimate(List<String> key) {
        return this.keyValues.getOrDefault(key, 0.0);
    }

    public Map<List<String>, Double> getKeyValues() {
        return this.keyValues;
    }

    public void setKeyValues(Map<List<String>, Double> keyValues) {
        this.keyValues = keyValues;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashMapCounter that = (HashMapCounter)o;
        return Objects.equals(this.keyValues, that.keyValues);
    }

    public int hashCode() {
        return Objects.hashCode(this.keyValues);
    }

    public String toString() {
        return "HashMapCounter{keyValues=" + String.valueOf(this.keyValues) + "}";
    }
}

