/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.algorithms.anomalylocalization;

import io.skylite.common.util.Counter;
import io.skylite.ml.common.algorithms.anomalylocalization.CountMinSketch;
import io.skylite.ml.common.algorithms.anomalylocalization.CountSketch;
import io.skylite.ml.common.algorithms.anomalylocalization.HashMapCounter;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HybridCounter
implements Counter {
    private static final Logger log = LogManager.getLogger(HybridCounter.class);
    protected static int SKETCH_THRESHOLD = 10000;
    private Counter counter = new HashMapCounter();
    private int count = 0;

    public void increment(List<String> key, double value) {
        this.counter.increment(key, value);
        this.updateCount();
    }

    public double estimate(List<String> key) {
        return this.counter.estimate(key);
    }

    private void updateCount() {
        ++this.count;
        if (this.count == SKETCH_THRESHOLD) {
            Map<List<String>, Double> hashmap = ((HashMapCounter)this.counter).getKeyValues();
            boolean hasNegative = hashmap.values().stream().anyMatch(v -> v < 0.0);
            Object newCounter = hasNegative ? new CountSketch() : new CountMinSketch();
            hashmap.forEach((arg_0, arg_1) -> HybridCounter.lambda$updateCount$1((Counter)newCounter, arg_0, arg_1));
            this.counter = newCounter;
        }
    }

    private static /* synthetic */ void lambda$updateCount$1(Counter newCounter, List k, Double v) {
        newCounter.increment(k, v.doubleValue());
    }
}

