/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.breaker;

import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.breaker.ThresholdCircuitBreaker;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.settings.MLCommonsSettings;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Optional;

public class DiskCircuitBreaker
extends ThresholdCircuitBreaker<ByteSizeValue> {
    private static final String ML_DISK_CB = "Disk Circuit Breaker";
    public static final ByteSizeValue DEFAULT_DISK_SHORTAGE_THRESHOLD = new ByteSizeValue(5L, ByteSizeUnit.GB);
    private final Path diskDir;

    public DiskCircuitBreaker(Settings settings, ClusterService clusterService, Path diskDir) {
        super(Optional.ofNullable((ByteSizeValue)MLCommonsSettings.ML_COMMONS_DISK_FREE_SPACE_THRESHOLD.get(settings)).orElse(DEFAULT_DISK_SHORTAGE_THRESHOLD));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_DISK_FREE_SPACE_THRESHOLD, x$0 -> super.setThreshold(x$0));
        this.diskDir = diskDir;
    }

    @Override
    public String getName() {
        return ML_DISK_CB;
    }

    @Override
    public boolean isOpen() {
        try {
            return AccessController.doPrivileged(() -> {
                FileStore fileStore = Environment.getFileStore((Path)this.diskDir);
                long freeSpace = fileStore.getUsableSpace();
                return new ByteSizeValue(freeSpace, ByteSizeUnit.BYTES).compareTo((ByteSizeValue)this.getThreshold()) < 0;
            });
        }
        catch (PrivilegedActionException e) {
            throw new MLException("Failed to run disk circuit breaker");
        }
    }
}

