/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.client;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.client.Configuration;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public class MLConfig
implements ToXContentObject,
Writeable {
    public static final String TYPE_FIELD = "type";
    public static final String CONFIGURATION_FIELD = "configuration";
    public static final String CREATE_TIME_FIELD = "create_time";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String CONFIG_TYPE_FIELD = "config_type";
    public static final String ML_CONFIGURATION_FIELD = "ml_configuration";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    private static final Version<?> MINIMAL_SUPPORTED_VERSION_FOR_NEW_CONFIG_FIELDS = CommonValue.VERSION_2_15_0;
    private String type;
    private String configType;
    private Configuration configuration;
    private Configuration mlConfiguration;
    private final Instant createTime;
    private Instant lastUpdateTime;
    private Instant lastUpdatedTime;
    private final String tenantId;

    public MLConfig(String type, String configType, Configuration configuration, Configuration mlConfiguration, Instant createTime, Instant lastUpdateTime, Instant lastUpdatedTime, String tenantId) {
        this.type = type;
        this.configType = configType;
        this.configuration = configuration;
        this.mlConfiguration = mlConfiguration;
        this.createTime = createTime;
        this.lastUpdateTime = lastUpdateTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.tenantId = tenantId;
    }

    public MLConfig(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.type = input.readOptionalString();
        if (input.readBoolean()) {
            this.configuration = new Configuration(input);
        }
        this.createTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_NEW_CONFIG_FIELDS)) {
            this.configType = input.readOptionalString();
            if (input.readBoolean()) {
                this.mlConfiguration = new Configuration(input);
            }
            this.lastUpdatedTime = input.readOptionalInstant();
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
    }

    public MLConfig setType(String type) {
        this.type = type;
        return this;
    }

    public MLConfig setConfigType(String configType) {
        this.configType = configType;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getConfigType() {
        return this.configType;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Configuration getMlConfiguration() {
        return this.mlConfiguration;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.type);
        if (this.configuration != null) {
            out.writeBoolean(true);
            this.configuration.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_NEW_CONFIG_FIELDS)) {
            out.writeOptionalString(this.configType);
            if (this.mlConfiguration != null) {
                out.writeBoolean(true);
                this.mlConfiguration.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalInstant(this.lastUpdatedTime);
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.configType != null || this.type != null) {
            builder.field(TYPE_FIELD, this.configType == null ? this.type : this.configType);
        }
        if (this.configuration != null || this.mlConfiguration != null) {
            builder.field(CONFIGURATION_FIELD, (ToXContent)(this.mlConfiguration == null ? this.configuration : this.mlConfiguration));
        }
        if (this.createTime != null) {
            builder.field(CREATE_TIME_FIELD, this.createTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null || this.lastUpdatedTime != null) {
            builder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdatedTime == null ? this.lastUpdateTime.toEpochMilli() : this.lastUpdatedTime.toEpochMilli());
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        return builder.endObject();
    }

    public static MLConfig fromStream(StreamInput in) throws IOException {
        return new MLConfig(in);
    }

    public static MLConfig parse(XContentParser parser) throws IOException {
        String type = null;
        String configType = null;
        Configuration configuration = null;
        Configuration mlConfiguration = null;
        Instant createTime = null;
        Instant lastUpdateTime = null;
        Instant lastUpdatedTime = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (fieldName == null) {
                parser.skipChildren();
                continue;
            }
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block20;
                }
                case "config_type": {
                    configType = parser.text();
                    continue block20;
                }
                case "configuration": {
                    configuration = Configuration.parse(parser);
                    continue block20;
                }
                case "ml_configuration": {
                    mlConfiguration = Configuration.parse(parser);
                    continue block20;
                }
                case "create_time": {
                    createTime = Instant.ofEpochMilli(parser.longValue());
                    continue block20;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block20;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block20;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return MLConfig.builder().type(type).configType(configType).configuration(configuration).mlConfiguration(mlConfiguration).createTime(createTime).lastUpdateTime(lastUpdateTime).lastUpdatedTime(lastUpdatedTime).tenantId(tenantId).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLConfig mlConfig = (MLConfig)o;
        return Objects.equals(this.type, mlConfig.type) && Objects.equals(this.configType, mlConfig.configType) && Objects.equals(this.configuration, mlConfig.configuration) && Objects.equals(this.mlConfiguration, mlConfig.mlConfiguration) && Objects.equals(this.createTime, mlConfig.createTime) && Objects.equals(this.lastUpdateTime, mlConfig.lastUpdateTime) && Objects.equals(this.lastUpdatedTime, mlConfig.lastUpdatedTime) && Objects.equals(this.tenantId, mlConfig.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.configType, this.configuration, this.mlConfiguration, this.createTime, this.lastUpdateTime, this.lastUpdatedTime, this.tenantId);
    }

    public static class Builder {
        private String type;
        private String configType;
        private Configuration configuration;
        private Configuration mlConfiguration;
        private Instant createTime;
        private Instant lastUpdateTime;
        private Instant lastUpdatedTime;
        private String tenantId;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder mlConfiguration(Configuration mlConfiguration) {
            this.mlConfiguration = mlConfiguration;
            return this;
        }

        public Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MLConfig build() {
            return new MLConfig(this.type, this.configType, this.configuration, this.mlConfiguration, this.createTime, this.lastUpdateTime, this.lastUpdatedTime, this.tenantId);
        }
    }
}

