/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.cluster;

import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TenantAwareHelper {
    public static boolean validateTenantId(MLFeatureEnabledSetting mlFeatureEnabledSetting, String tenantId, ActionListener<?> listener) {
        if (mlFeatureEnabledSetting.isMultiTenancyEnabled() && tenantId == null) {
            listener.onFailure((Exception)new SkyliteStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean validateTenantResource(MLFeatureEnabledSetting mlFeatureEnabledSetting, String tenantIdFromRequest, String tenantIdFromResource, ActionListener<?> listener) {
        if (mlFeatureEnabledSetting.isMultiTenancyEnabled() && !Objects.equals(tenantIdFromRequest, tenantIdFromResource)) {
            listener.onFailure((Exception)new SkyliteStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean isTenantFilteringEnabled(SearchRequest searchRequest) {
        QueryBuilder queryBuilder;
        SearchSourceBuilder searchSourceBuilder = searchRequest.source();
        if (searchSourceBuilder != null && (queryBuilder = searchSourceBuilder.query()) instanceof TermQueryBuilder) {
            TermQueryBuilder termQuery = (TermQueryBuilder)queryBuilder;
            return "tenant_id".equals(termQuery.fieldName());
        }
        return false;
    }

    public static String getTenantID(Boolean isMultiTenancyEnabled, RestRequest restRequest) {
        if (!isMultiTenancyEnabled.booleanValue()) {
            return null;
        }
        Map headers = restRequest.getHeaders();
        if (headers == null) {
            throw new SkyliteStatusException("Rest request headers can't be null", RestStatus.FORBIDDEN, new Object[0]);
        }
        List tenantIdList = (List)headers.get("x-tenant-id");
        if (tenantIdList == null || tenantIdList.isEmpty()) {
            throw new SkyliteStatusException("Tenant ID header is missing or has no value", RestStatus.FORBIDDEN, new Object[0]);
        }
        String tenantId = (String)tenantIdList.get(0);
        if (tenantId == null) {
            throw new SkyliteStatusException("Tenant ID can't be null", RestStatus.FORBIDDEN, new Object[0]);
        }
        return tenantId;
    }
}

