/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector;

import io.skylite.LuceniaVersion;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.connector.RetryBackoffPolicy;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public class ConnectorClientConfig
implements ToXContentObject,
Writeable {
    public static final String MAX_CONNECTION_FIELD = "max_connection";
    public static final String MAX_CONNECTIONS_PER_ROUTE_AS_PCT_FIELD = "percent_max_connection_per_route";
    public static final String CONNECTION_TIMEOUT_FIELD = "connection_timeout";
    public static final String READ_TIMEOUT_FIELD = "read_timeout";
    public static final String RETRY_BACKOFF_MILLIS_FIELD = "retry_backoff_millis";
    public static final String RETRY_TIMEOUT_SECONDS_FIELD = "retry_timeout_seconds";
    public static final String MAX_RETRY_TIMES_FIELD = "max_retry_times";
    public static final String RETRY_BACKOFF_POLICY_FIELD = "retry_backoff_policy";
    public static final int MAX_CONNECTION_DEFAULT_VALUE = 30;
    public static final double MAX_CONNECTION_PER_ROUTE_AS_PERCENT_DEFAULT = 0.3333333333333333;
    public static final int CONNECTION_TIMEOUT_DEFAULT_VALUE = 30000;
    public static final int READ_TIMEOUT_DEFAULT_VALUE = 30000;
    public static final int RETRY_BACKOFF_MILLIS_DEFAULT_VALUE = 200;
    public static final int RETRY_TIMEOUT_SECONDS_DEFAULT_VALUE = 30;
    public static final int MAX_RETRY_TIMES_DEFAULT_VALUE = 0;
    public static final RetryBackoffPolicy RETRY_BACKOFF_POLICY_DEFAULT_VALUE = RetryBackoffPolicy.CONSTANT;
    public static final Version<?> MINIMAL_SUPPORTED_VERSION_FOR_RETRY = OpenSearchVersion.fromId((int)2150099);
    private Integer maxConnections;
    private Double maxConnectionsPerRouteAsPercent;
    private Integer connectionTimeout;
    private Integer readTimeout;
    private Integer retryBackoffMillis;
    private Integer retryTimeoutSeconds;
    private Integer maxRetryTimes;
    private RetryBackoffPolicy retryBackoffPolicy;

    public ConnectorClientConfig(int maxConnections, double maxConnectionsPerRouteAsPercent, int connectionTimeout, int readTimeout, int retryBackoffMillis, int retryTimeoutSeconds, int maxRetryTimes, RetryBackoffPolicy retryBackoffPolicy) {
        this.maxConnections = maxConnections;
        this.maxConnectionsPerRouteAsPercent = maxConnectionsPerRouteAsPercent;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.retryBackoffMillis = retryBackoffMillis;
        this.retryTimeoutSeconds = retryTimeoutSeconds;
        this.maxRetryTimes = maxRetryTimes;
        this.retryBackoffPolicy = retryBackoffPolicy;
    }

    public ConnectorClientConfig(int maxConnections, int connectionTimeout, int readTimeout, int retryBackoffMillis, int retryTimeoutSeconds, int maxRetryTimes, RetryBackoffPolicy retryBackoffPolicy) {
        this.maxConnections = maxConnections;
        this.maxConnectionsPerRouteAsPercent = 0.3333333333333333;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.retryBackoffMillis = retryBackoffMillis;
        this.retryTimeoutSeconds = retryTimeoutSeconds;
        this.maxRetryTimes = maxRetryTimes;
        this.retryBackoffPolicy = retryBackoffPolicy;
    }

    public ConnectorClientConfig(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.maxConnections = input.readOptionalInt();
        this.maxConnectionsPerRouteAsPercent = input.getVersion().onOrAfter((Version)LuceniaVersion.V_0_4_0) ? input.readOptionalDouble() : Double.valueOf(0.3333333333333333);
        this.connectionTimeout = input.readOptionalInt();
        this.readTimeout = input.readOptionalInt();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_RETRY)) {
            this.retryBackoffMillis = input.readOptionalInt();
            this.retryTimeoutSeconds = input.readOptionalInt();
            this.maxRetryTimes = input.readOptionalInt();
            if (input.readBoolean()) {
                this.retryBackoffPolicy = RetryBackoffPolicy.from(input.readString());
            }
        }
    }

    public ConnectorClientConfig() {
        this.maxConnections = MAX_CONNECTION_DEFAULT_VALUE;
        this.maxConnectionsPerRouteAsPercent = 0.3333333333333333;
        this.connectionTimeout = CONNECTION_TIMEOUT_DEFAULT_VALUE;
        this.readTimeout = READ_TIMEOUT_DEFAULT_VALUE;
        this.retryBackoffMillis = 200;
        this.retryTimeoutSeconds = 30;
        this.maxRetryTimes = 0;
        this.retryBackoffPolicy = RETRY_BACKOFF_POLICY_DEFAULT_VALUE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalInt(this.maxConnections);
        if (out.getVersion().onOrAfter((Version)LuceniaVersion.V_0_4_0)) {
            out.writeOptionalDouble(this.maxConnectionsPerRouteAsPercent);
        }
        out.writeOptionalInt(this.connectionTimeout);
        out.writeOptionalInt(this.readTimeout);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_RETRY)) {
            out.writeOptionalInt(this.retryBackoffMillis);
            out.writeOptionalInt(this.retryTimeoutSeconds);
            out.writeOptionalInt(this.maxRetryTimes);
            if (Objects.nonNull((Object)this.retryBackoffPolicy)) {
                out.writeBoolean(true);
                out.writeString(this.retryBackoffPolicy.name());
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public double getMaxConnectionsPerRouteAsPercent() {
        return this.maxConnectionsPerRouteAsPercent;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getRetryBackoffMillis() {
        return this.retryBackoffMillis;
    }

    public Integer getRetryTimeoutSeconds() {
        return this.retryTimeoutSeconds;
    }

    public Integer getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public RetryBackoffPolicy getRetryBackoffPolicy() {
        return this.retryBackoffPolicy;
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.maxConnections != null) {
            builder.field(MAX_CONNECTION_FIELD, this.maxConnections);
        }
        if (this.connectionTimeout != null) {
            builder.field(CONNECTION_TIMEOUT_FIELD, this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            builder.field(READ_TIMEOUT_FIELD, this.readTimeout);
        }
        if (this.retryBackoffMillis != null) {
            builder.field(RETRY_BACKOFF_MILLIS_FIELD, this.retryBackoffMillis);
        }
        if (this.retryTimeoutSeconds != null) {
            builder.field(RETRY_TIMEOUT_SECONDS_FIELD, this.retryTimeoutSeconds);
        }
        if (this.maxRetryTimes != null) {
            builder.field(MAX_RETRY_TIMES_FIELD, this.maxRetryTimes);
        }
        if (this.retryBackoffPolicy != null) {
            builder.field(RETRY_BACKOFF_POLICY_FIELD, this.retryBackoffPolicy.name().toLowerCase(Locale.ROOT));
        }
        return builder.endObject();
    }

    public static ConnectorClientConfig fromStream(StreamInput in) throws IOException {
        ConnectorClientConfig connectorClientConfig = new ConnectorClientConfig(in);
        return connectorClientConfig;
    }

    public static ConnectorClientConfig parse(XContentParser parser) throws IOException {
        Integer maxConnections = MAX_CONNECTION_DEFAULT_VALUE;
        Double maxConnectionsPerRouteAsPercent = 0.3333333333333333;
        Integer connectionTimeout = CONNECTION_TIMEOUT_DEFAULT_VALUE;
        Integer readTimeout = READ_TIMEOUT_DEFAULT_VALUE;
        Integer retryBackoffMillis = 200;
        Integer retryTimeoutSeconds = 30;
        Integer maxRetryTimes = 0;
        RetryBackoffPolicy retryBackoffPolicy = RETRY_BACKOFF_POLICY_DEFAULT_VALUE;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "max_connection": {
                    maxConnections = parser.intValue();
                    continue block20;
                }
                case "percent_max_connection_per_route": {
                    maxConnectionsPerRouteAsPercent = parser.doubleValue();
                    continue block20;
                }
                case "connection_timeout": {
                    connectionTimeout = parser.intValue();
                    continue block20;
                }
                case "read_timeout": {
                    readTimeout = parser.intValue();
                    continue block20;
                }
                case "retry_backoff_millis": {
                    retryBackoffMillis = parser.intValue();
                    continue block20;
                }
                case "retry_timeout_seconds": {
                    retryTimeoutSeconds = parser.intValue();
                    continue block20;
                }
                case "max_retry_times": {
                    maxRetryTimes = parser.intValue();
                    continue block20;
                }
                case "retry_backoff_policy": {
                    retryBackoffPolicy = RetryBackoffPolicy.from(parser.text());
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return ConnectorClientConfig.builder().maxConnections(maxConnections).maxConnectionsPerRouteAsPercent(maxConnectionsPerRouteAsPercent).connectionTimeout(connectionTimeout).readTimeout(readTimeout).retryBackoffMillis(retryBackoffMillis).retryTimeoutSeconds(retryTimeoutSeconds).maxRetryTimes(maxRetryTimes).retryBackoffPolicy(retryBackoffPolicy).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorClientConfig that = (ConnectorClientConfig)o;
        return Objects.equals(this.maxConnections, that.maxConnections) && Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.retryBackoffMillis, that.retryBackoffMillis) && Objects.equals(this.retryTimeoutSeconds, that.retryTimeoutSeconds) && Objects.equals(this.maxRetryTimes, that.maxRetryTimes) && Objects.equals((Object)this.retryBackoffPolicy, (Object)that.retryBackoffPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxConnections, this.connectionTimeout, this.readTimeout, this.retryBackoffMillis, this.retryTimeoutSeconds, this.maxRetryTimes, this.retryBackoffPolicy});
    }

    public static class Builder {
        private int maxConnections;
        private double maxConnectionsPerRouteAsPercent;
        private int connectionTimeout;
        private int readTimeout;
        private int retryBackoffMillis;
        private int retryTimeoutSeconds;
        private int maxRetryTimes;
        private RetryBackoffPolicy retryBackoffPolicy;

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxConnectionsPerRouteAsPercent(double maxConnectionsPerRouteAsPercent) {
            this.maxConnectionsPerRouteAsPercent = maxConnectionsPerRouteAsPercent;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder retryBackoffMillis(int retryBackoffMillis) {
            this.retryBackoffMillis = retryBackoffMillis;
            return this;
        }

        public Builder retryTimeoutSeconds(int retryTimeoutSeconds) {
            this.retryTimeoutSeconds = retryTimeoutSeconds;
            return this;
        }

        public Builder maxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public Builder retryBackoffPolicy(RetryBackoffPolicy retryBackoffPolicy) {
            this.retryBackoffPolicy = retryBackoffPolicy;
            return this;
        }

        public ConnectorClientConfig build() {
            return new ConnectorClientConfig(this.maxConnections, this.maxConnectionsPerRouteAsPercent, this.connectionTimeout, this.readTimeout, this.retryBackoffMillis, this.retryTimeoutSeconds, this.maxRetryTimes, this.retryBackoffPolicy);
        }
    }
}

