/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector;

import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.connector.ConnectorClientConfig;
import io.skylite.ml.common.connector.ConnectorProtocols;
import io.skylite.ml.common.output.model.ModelTensor;
import io.skylite.ml.common.transport.connector.MLCreateConnectorInput;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@io.skylite.ml.common.annotation.Connector(value="mcp_streamable_http")
public class McpConnector
implements Connector {
    private static final Logger log = LogManager.getLogger(McpConnector.class);
    protected String name;
    protected String description;
    protected String version;
    protected String protocol;
    protected Map<String, String> credential;
    protected Map<String, String> decryptedHeaders;
    protected Map<String, String> parameters;
    protected Map<String, String> decryptedCredential;
    protected List<String> backendRoles;
    protected User owner;
    protected AccessMode access;
    protected Instant createdTime;
    protected Instant lastUpdateTime;
    protected ConnectorClientConfig connectorClientConfig;
    protected String tenantId;
    protected String url;
    protected Map<String, String> headers;

    public McpConnector() {
    }

    public McpConnector(String name, String description, String version, String protocol, Map<String, String> credential, List<String> backendRoles, AccessMode accessMode, User owner, ConnectorClientConfig connectorClientConfig, String tenantId, String url, Map<String, String> headers, Map<String, String> parameters) {
        ConnectorProtocols.validateProtocol(protocol);
        this.name = name;
        this.description = description;
        this.version = version;
        this.protocol = protocol;
        this.credential = credential;
        this.backendRoles = backendRoles;
        this.access = accessMode;
        this.owner = owner;
        this.connectorClientConfig = connectorClientConfig;
        this.tenantId = tenantId;
        this.url = url;
        this.headers = headers;
        this.parameters = parameters;
    }

    public McpConnector(String protocol, XContentParser parser) throws IOException {
        this.protocol = protocol;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block34: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    this.name = parser.text();
                    continue block34;
                }
                case "version": {
                    this.version = parser.text();
                    continue block34;
                }
                case "description": {
                    this.description = parser.text();
                    continue block34;
                }
                case "protocol": {
                    this.protocol = parser.text();
                    continue block34;
                }
                case "credential": {
                    this.credential = new HashMap<String, String>();
                    this.credential.putAll(parser.mapStrings());
                    continue block34;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    this.backendRoles = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.backendRoles.add(parser.text());
                    }
                    continue block34;
                }
                case "owner": {
                    this.owner = User.parse((XContentParser)parser);
                    continue block34;
                }
                case "access": {
                    this.access = AccessMode.from(parser.text());
                    continue block34;
                }
                case "created_time": {
                    this.createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block34;
                }
                case "last_updated_time": {
                    this.lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block34;
                }
                case "client_config": {
                    this.connectorClientConfig = ConnectorClientConfig.parse(parser);
                    continue block34;
                }
                case "tenant_id": {
                    this.tenantId = parser.textOrNull();
                    continue block34;
                }
                case "url": {
                    this.url = parser.textOrNull();
                    continue block34;
                }
                case "headers": {
                    this.headers = new HashMap<String, String>();
                    this.headers.putAll(parser.mapStrings());
                    continue block34;
                }
                case "parameters": {
                    this.parameters = new HashMap<String, String>();
                    this.parameters.putAll(parser.mapStrings());
                    continue block34;
                }
            }
            parser.skipChildren();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void setDecryptedCredential(Map<String, String> decryptedCredential) {
        this.decryptedCredential = decryptedCredential;
    }

    @Override
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Override
    public void setOwner(User owner) {
        this.owner = owner;
    }

    public void setAccessMode(AccessMode access) {
        this.access = access;
    }

    @Override
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setConnectorClientConfig(ConnectorClientConfig connectorClientConfig) {
        this.connectorClientConfig = connectorClientConfig;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    protected Map<String, String> createDecryptedHeaders(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, String> decryptedHeaders = new HashMap<String, String>();
        StringSubstitutor substitutor = new StringSubstitutor(this.getDecryptedCredential(), "${credential.", "}");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            decryptedHeaders.put(entry.getKey(), substitutor.replace(entry.getValue()));
        }
        return decryptedHeaders;
    }

    @Override
    public void decrypt(String action, BiFunction<String, String, String> function, String tenantId) {
        HashMap<String, String> decrypted = new HashMap<String, String>();
        for (String key : this.credential.keySet()) {
            decrypted.put(key, function.apply(this.credential.get(key), tenantId));
        }
        this.decryptedCredential = decrypted;
        this.decryptedHeaders = this.createDecryptedHeaders(this.headers);
    }

    @Override
    public void encrypt(BiFunction<String, String, String> function, String tenantId) {
        for (String key : this.credential.keySet()) {
            String encrypted = function.apply(this.credential.get(key), tenantId);
            this.credential.put(key, encrypted);
        }
    }

    @Override
    public Connector cloneConnector() {
        McpConnector mcpConnector;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            StreamInput streamInput = bytesStreamOutput.bytes().streamInput();
            mcpConnector = new McpConnector(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bytesStreamOutput.close();
        return mcpConnector;
    }

    public McpConnector(StreamInput input) throws IOException {
        this.protocol = input.readString();
        this.parseFromStream(input);
    }

    private void parseFromStream(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readOptionalString();
        this.version = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.credential = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.backendRoles = input.readOptionalStringList();
        if (input.readBoolean()) {
            this.access = (AccessMode)input.readEnum(AccessMode.class);
        }
        if (input.readBoolean()) {
            this.owner = new User(input);
        }
        this.createdTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        if (input.readBoolean()) {
            this.connectorClientConfig = new ConnectorClientConfig(input);
        }
        this.tenantId = input.readOptionalString();
        this.url = input.readString();
        if (input.readBoolean()) {
            this.headers = input.readMap(s -> s.readString(), s -> s.readString());
        }
        if (streamInputVersion.onOrAfter((Version)LuceniaVersion.V_0_7_0) && input.readBoolean()) {
            this.parameters = input.readMap(s -> s.readString(), s -> s.readString());
        }
    }

    @Override
    public void removeCredential() {
        this.credential = null;
        this.decryptedCredential = null;
        this.decryptedHeaders = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.protocol);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        if (this.credential != null) {
            out.writeBoolean(true);
            out.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalStringCollection(this.backendRoles);
        if (this.access != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.access);
        } else {
            out.writeBoolean(false);
        }
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        if (this.connectorClientConfig != null) {
            out.writeBoolean(true);
            this.connectorClientConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
        out.writeString(this.url);
        if (this.headers != null) {
            out.writeBoolean(true);
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter((Version)LuceniaVersion.V_0_7_0)) {
            if (this.parameters != null) {
                out.writeBoolean(true);
                out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public void update(MLCreateConnectorInput updateContent, BiFunction<String, String, String> function) {
        if (updateContent.getName() != null) {
            this.name = updateContent.getName();
        }
        if (updateContent.getDescription() != null) {
            this.description = updateContent.getDescription();
        }
        if (updateContent.getVersion() != null) {
            this.version = updateContent.getVersion();
        }
        if (updateContent.getProtocol() != null) {
            this.protocol = updateContent.getProtocol();
        }
        if (updateContent.getCredential() != null && !updateContent.getCredential().isEmpty()) {
            this.credential = updateContent.getCredential();
            this.encrypt(function, this.tenantId);
        }
        if (updateContent.getBackendRoles() != null) {
            this.backendRoles = updateContent.getBackendRoles();
        }
        if (updateContent.getAccess() != null) {
            this.access = updateContent.getAccess();
        }
        if (updateContent.getConnectorClientConfig() != null) {
            this.connectorClientConfig = updateContent.getConnectorClientConfig();
        }
        if (updateContent.getUrl() != null) {
            this.url = updateContent.getUrl();
        }
        if (updateContent.getHeaders() != null) {
            this.headers = updateContent.getHeaders();
        }
        if (updateContent.getParameters() != null) {
            this.parameters = updateContent.getParameters();
        }
    }

    @Override
    public <T> void parseResponse(T orElse, List<ModelTensor> modelTensors, boolean b) throws IOException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.version != null) {
            builder.field("version", this.version);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.protocol != null) {
            builder.field("protocol", this.protocol);
        }
        if (this.credential != null) {
            builder.field("credential", this.credential);
        }
        if (this.backendRoles != null) {
            builder.field("backend_roles", this.backendRoles);
        }
        if (this.owner != null) {
            builder.field("owner", (ToXContent)this.owner);
        }
        if (this.access != null) {
            builder.field("access", this.access.getValue());
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field("last_updated_time", this.lastUpdateTime.toEpochMilli());
        }
        if (this.connectorClientConfig != null) {
            builder.field("client_config", (ToXContent)this.connectorClientConfig);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        if (this.url != null) {
            builder.field("url", this.url);
        }
        if (this.headers != null) {
            builder.field("headers", this.headers);
        }
        if (this.parameters != null) {
            builder.field("parameters", this.parameters);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void validateConnectorURL(List<String> urlRegexes) {
        boolean hasMatchedUrl = false;
        for (String urlRegex : urlRegexes) {
            Pattern pattern = Pattern.compile(urlRegex);
            Matcher matcher = pattern.matcher(this.url);
            if (!matcher.matches()) continue;
            hasMatchedUrl = true;
            break;
        }
        if (!hasMatchedUrl) {
            throw new IllegalArgumentException("Connector URL is not matching the trusted connector endpoint regex");
        }
    }

    @Override
    public Map<String, String> getDecryptedHeaders() {
        return this.decryptedHeaders;
    }

    @Override
    public Map<String, String> getDecryptedCredential() {
        return this.decryptedCredential;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public AccessMode getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(AccessMode access) {
        this.access = access;
    }

    @Override
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public List<ConnectorAction> getActions() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public void addAction(ConnectorAction action) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public ConnectorClientConfig getConnectorClientConfig() {
        return this.connectorClientConfig;
    }

    @Override
    public String getActionEndpoint(String action, Map<String, String> parameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public String getActionHttpMethod(String action) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> T createPayload(String action, Map<String, String> parameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public Optional<ConnectorAction> findAction(String action) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public HttpRequest buildSdkRequest(String action, Map<String, String> parameters, String payload, RestRequest.Method method) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getCredential() {
        return this.credential;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof McpConnector)) {
            return false;
        }
        McpConnector that = (McpConnector)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.version, that.version) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.credential, that.credential) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.backendRoles, that.backendRoles) && Objects.equals(this.owner, that.owner) && Objects.equals((Object)this.access, (Object)that.access) && Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.lastUpdateTime, that.lastUpdateTime) && Objects.equals(this.connectorClientConfig, that.connectorClientConfig) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.url, that.url) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.version, this.protocol, this.credential, this.parameters, this.backendRoles, this.owner, this.access, this.createdTime, this.lastUpdateTime, this.connectorClientConfig, this.tenantId, this.url, this.headers});
    }

    public static class Builder {
        private String name;
        private String description;
        private String version;
        private String protocol;
        private Map<String, String> credential;
        private List<String> backendRoles;
        private User owner;
        private AccessMode access;
        private ConnectorClientConfig connectorClientConfig;
        private String tenantId;
        private String url;
        private Map<String, String> headers;
        private Map<String, String> parameters;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        public Builder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public Builder owner(User owner) {
            this.owner = owner;
            return this;
        }

        public Builder access(AccessMode access) {
            this.access = access;
            return this;
        }

        public Builder connectorClientConfig(ConnectorClientConfig connectorClientConfig) {
            this.connectorClientConfig = connectorClientConfig;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder accessMode(AccessMode access) {
            this.access = access;
            return this;
        }

        public McpConnector build() {
            return new McpConnector(this.name, this.description, this.version, this.protocol, this.credential, this.backendRoles, this.access, this.owner, this.connectorClientConfig, this.tenantId, this.url, this.headers, this.parameters);
        }
    }
}

