/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector.functions.preprocess;

import io.skylite.core.common.Strings;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.ScriptType;
import io.skylite.core.script.TemplateScript;
import io.skylite.ml.common.dataset.TextDocsInputDataSet;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.input.MLInput;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConnectorPreProcessFunction
implements Function<MLInput, RemoteInferenceInputDataSet> {
    private static final Logger log = LogManager.getLogger(ConnectorPreProcessFunction.class);
    protected boolean returnDirectlyForRemoteInferenceInput;

    @Override
    public RemoteInferenceInputDataSet apply(MLInput mlInput) {
        if (mlInput == null) {
            throw new IllegalArgumentException("Preprocess function input can't be null");
        }
        if (this.returnDirectlyForRemoteInferenceInput && mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet) {
            return (RemoteInferenceInputDataSet)mlInput.getInputDataset();
        }
        this.validate(mlInput);
        return this.process(mlInput);
    }

    public abstract void validate(MLInput var1);

    public abstract RemoteInferenceInputDataSet process(MLInput var1);

    public void validateTextDocsInput(MLInput mlInput) {
        if (!(mlInput.getInputDataset() instanceof TextDocsInputDataSet)) {
            log.error(String.format(Locale.ROOT, "This pre_process_function can only support TextDocsInputDataSet, actual input type is: %s", mlInput.getInputDataset().getClass().getName()));
            throw new IllegalArgumentException("This pre_process_function can only support TextDocsInputDataSet which including a list of string with key 'text_docs'");
        }
    }

    protected String executeScript(ScriptService scriptService, String painlessScript, Map<String, Object> params) {
        Script script = new Script(ScriptType.INLINE, "painless", Strings.addDefaultMethod((String)painlessScript), Collections.emptyMap());
        TemplateScript templateScript = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(params);
        return templateScript.execute();
    }

    public static Map<String, String> convertScriptStringToJsonString(Map<String, Object> processedInput) {
        HashMap<String, String> parameterStringMap = new HashMap<String, String>();
        try {
            AccessController.doPrivileged(() -> {
                Map parametersMap = processedInput.getOrDefault("parameters", Map.of());
                for (String key : parametersMap.keySet()) {
                    if (parametersMap.get(key) instanceof String) {
                        parameterStringMap.put(key, (String)parametersMap.get(key));
                        continue;
                    }
                    parameterStringMap.put(key, Strings.toJson(parametersMap.get(key)));
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            log.error("Error processing parameters", (Throwable)e);
            throw new RuntimeException(e);
        }
        return parameterStringMap;
    }
}

