/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector.functions.preprocess;

import io.skylite.core.common.Strings;
import io.skylite.core.script.ScriptService;
import io.skylite.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.input.MLInput;
import java.util.HashMap;
import java.util.Map;

public class RemoteInferencePreProcessFunction
extends ConnectorPreProcessFunction {
    public static final String CONVERT_REMOTE_INFERENCE_PARAM_TO_OBJECT = "pre_process_function.convert_remote_inference_param_to_object";
    private final ScriptService scriptService;
    private final String preProcessFunction;
    private final Map<String, String> params;

    public RemoteInferencePreProcessFunction(ScriptService scriptService, String preProcessFunction, Map<String, String> params) {
        this.returnDirectlyForRemoteInferenceInput = false;
        this.scriptService = scriptService;
        this.preProcessFunction = preProcessFunction;
        this.params = params;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate(MLInput mlInput) {
        if (!(mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet)) {
            throw new IllegalArgumentException("This pre_process_function can only support RemoteInferenceInputDataSet");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        Map<String, String> parameters = ((RemoteInferenceInputDataSet)mlInput.getInputDataset()).getParameters();
        if (this.params.containsKey(CONVERT_REMOTE_INFERENCE_PARAM_TO_OBJECT) && Boolean.parseBoolean(this.params.get(CONVERT_REMOTE_INFERENCE_PARAM_TO_OBJECT))) {
            for (String key : parameters.keySet()) {
                if (Strings.isJson((String)parameters.get(key))) {
                    inputParams.put(key, Strings.fromJson((String)parameters.get(key), Object.class));
                    continue;
                }
                inputParams.put(key, parameters.get(key));
            }
        } else {
            inputParams.putAll(parameters);
        }
        String processedInput = this.executeScript(this.scriptService, this.preProcessFunction, inputParams);
        if (processedInput == null) {
            throw new IllegalArgumentException("Preprocess function output is null");
        }
        Map map = (Map)Strings.fromJson((String)processedInput, Map.class);
        return RemoteInferenceInputDataSet.builder().parameters(RemoteInferencePreProcessFunction.convertScriptStringToJsonString(map)).build();
    }

    public static class Builder {
        private ScriptService scriptService;
        private String preProcessFunction;
        private Map<String, String> params;

        public Builder scriptService(ScriptService scriptService) {
            this.scriptService = scriptService;
            return this;
        }

        public Builder preProcessFunction(String preProcessFunction) {
            this.preProcessFunction = preProcessFunction;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public RemoteInferencePreProcessFunction build() {
            return new RemoteInferencePreProcessFunction(this.scriptService, this.preProcessFunction, this.params);
        }
    }
}

