/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataframe;

import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.ml.common.dataframe.ColumnType;
import io.skylite.ml.common.dataframe.ColumnValue;
import java.io.IOException;

public class FloatValue
implements ColumnValue {
    private final float value;

    public FloatValue(float value) {
        this.value = value;
    }

    @Override
    public ColumnType columnType() {
        return ColumnType.FLOAT;
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public double doubleValue() {
        return Float.valueOf(this.value).doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.columnType());
        out.writeFloat(this.value);
    }

    public String toString() {
        return "FloatValue{value=" + this.value + "}";
    }
}

